/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.nosql.Value;
import jakarta.nosql.keyvalue.KeyValueEntity;
import jakarta.nosql.mapping.AttributeConverter;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.IdNotFoundException;
import jakarta.nosql.mapping.keyvalue.KeyValueEntityConverter;
import java.util.Objects;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;

public abstract class AbstractKeyValueEntityConverter
implements KeyValueEntityConverter {
    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    public KeyValueEntity toKeyValue(Object entity) {
        Objects.requireNonNull(entity, "entity is required");
        Class<?> type = entity.getClass();
        FieldMapping key = this.getId(type);
        Object value = key.read(entity);
        Objects.requireNonNull(value, String.format("The key field %s is required", key.getName()));
        return KeyValueEntity.of((Object)this.getKey(value, type, false), (Object)entity);
    }

    public <T> T toEntity(Class<T> type, KeyValueEntity entity) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(entity, "entity is required");
        Object bean = entity.getValue(type);
        if (Objects.isNull(bean)) {
            return null;
        }
        Object key = this.getKey(entity.getKey(), type, true);
        FieldMapping id = this.getId(type);
        id.write(bean, key);
        return (T)bean;
    }

    private <T> Object getKey(Object key, Class<T> type, boolean toEntity) {
        FieldMapping id = this.getId(type);
        if (id.getConverter().isPresent()) {
            AttributeConverter attributeConverter = this.getConverters().get((Class)id.getConverter().get());
            if (toEntity) {
                return attributeConverter.convertToEntityAttribute(key);
            }
            return attributeConverter.convertToDatabaseColumn(key);
        }
        return Value.of((Object)key).get(id.getNativeField().getType());
    }

    private FieldMapping getId(Class<?> type) {
        EntityMetadata mapping = this.getEntities().get(type);
        return (FieldMapping)mapping.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
    }
}

