/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.keyvalue.KeyValueEntity;
import jakarta.nosql.mapping.PreparedStatement;
import jakarta.nosql.mapping.keyvalue.KeyValueEntityConverter;
import jakarta.nosql.mapping.keyvalue.KeyValueEventPersistManager;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplate;
import jakarta.nosql.mapping.keyvalue.KeyValueWorkflow;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.mapping.keyvalue.KeyValuePreparedStatement;

public abstract class AbstractKeyValueTemplate
implements KeyValueTemplate {
    protected abstract KeyValueEntityConverter getConverter();

    protected abstract BucketManager getManager();

    protected abstract KeyValueWorkflow getFlow();

    protected abstract KeyValueEventPersistManager getEventManager();

    public <T> T put(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        UnaryOperator putAction = k -> {
            this.getManager().put(k);
            return k;
        };
        return (T)this.getFlow().flow(entity, putAction);
    }

    public <T> T put(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl class is required");
        UnaryOperator putAction = k -> {
            this.getManager().put(k, ttl);
            return k;
        };
        return (T)this.getFlow().flow(entity, putAction);
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        return this.put(entities);
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        return this.put(entities, ttl);
    }

    public <T> T update(T entity) {
        return this.put(entity);
    }

    public <T> Iterable<T> update(Iterable<T> entities) {
        return this.put(entities);
    }

    public <T> T insert(T entity) {
        return this.put(entity);
    }

    public <T> T insert(T entity, Duration ttl) {
        return this.put(entity, ttl);
    }

    public <K, T> Optional<T> get(K key, Class<T> type) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(type, "entity class is required");
        Optional value = this.getManager().get(key);
        return value.map(v -> this.getConverter().toEntity(type, KeyValueEntity.of((Object)key, (Object)v))).filter(Objects::nonNull).map(e -> {
            this.getEventManager().firePostEntity(e);
            return e;
        });
    }

    public <K, T> Iterable<T> get(Iterable<K> keys, Class<T> type) {
        Objects.requireNonNull(keys, "keys is required");
        Objects.requireNonNull(type, "type class is required");
        return StreamSupport.stream(keys.spliterator(), false).map(k -> this.getManager().get(k).map(v -> KeyValueEntity.of((Object)k, (Object)v))).filter(Optional::isPresent).map(e -> this.getConverter().toEntity(type, (KeyValueEntity)e.get())).collect(Collectors.toList());
    }

    public <K> void delete(K key) {
        Objects.requireNonNull(key, "key is required");
        this.getManager().delete(key);
    }

    public <K> void delete(Iterable<K> keys) {
        Objects.requireNonNull(keys, "keys is required");
        this.getManager().delete(keys);
    }

    public <T> Stream<T> query(String query, Class<T> type) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(type, "type is required");
        Stream values = this.getManager().query(query);
        return values.map(v -> v.get(type));
    }

    public <T> Optional<T> getSingleResult(String query, Class<T> type) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(type, "type is required");
        Stream<T> entities = this.query(query, type);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No Unique result found to the query: " + query);
    }

    public void query(String query) {
        Objects.requireNonNull(query, "query is required");
        this.getManager().query(query);
    }

    public <T> PreparedStatement prepare(String query, Class<T> type) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(type, "type is required");
        return new KeyValuePreparedStatement(this.getManager().prepare(query), type);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        return this.get(id, type);
    }

    public <T, K> void delete(Class<T> type, K id) {
        this.delete(id);
    }
}

