/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.nosql.keyvalue.KeyValueEntity;
import jakarta.nosql.mapping.keyvalue.KeyValueEntityConverter;
import jakarta.nosql.mapping.keyvalue.KeyValueEventPersistManager;
import jakarta.nosql.mapping.keyvalue.KeyValueWorkflow;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class AbstractKeyValueWorkflow
implements KeyValueWorkflow {
    protected abstract KeyValueEventPersistManager getEventManager();

    protected abstract KeyValueEntityConverter getConverter();

    public <T> T flow(T entity, UnaryOperator<KeyValueEntity> action) {
        Function<T, T> flow = this.getFlow(entity, action);
        return flow.apply(entity);
    }

    private <T> Function<T, T> getFlow(T entity, UnaryOperator<KeyValueEntity> action) {
        UnaryOperator validation = t -> Objects.requireNonNull(t, "entity is required");
        UnaryOperator firePreEntity = t -> {
            this.getEventManager().firePreEntity(t);
            return t;
        };
        UnaryOperator firePreKeyValueEntity = t -> {
            this.getEventManager().firePreKeyValueEntity(t);
            return t;
        };
        Function<Object, KeyValueEntity> convertKeyValue = t -> this.getConverter().toKeyValue(t);
        UnaryOperator firePreDocument = t -> {
            this.getEventManager().firePreKeyValue(t);
            return t;
        };
        UnaryOperator firePostDocument = t -> {
            this.getEventManager().firePostKeyValue(t);
            return t;
        };
        Function<KeyValueEntity, Object> converterEntity = t -> this.getConverter().toEntity(entity.getClass(), t);
        UnaryOperator firePostEntity = t -> {
            this.getEventManager().firePostEntity(t);
            return t;
        };
        UnaryOperator firePostKeyValueEntity = t -> {
            this.getEventManager().firePostKeyValueEntity(t);
            return t;
        };
        return validation.andThen(firePreEntity).andThen(firePreKeyValueEntity).andThen(convertKeyValue).andThen(firePreDocument).andThen(action).andThen(firePostDocument).andThen(converterEntity).andThen(firePostEntity).andThen(firePostKeyValueEntity);
    }
}

