/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.nosql.mapping.PreparedStatement;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

final class KeyValuePreparedStatement
implements PreparedStatement {
    private final jakarta.nosql.keyvalue.KeyValuePreparedStatement preparedStatement;
    private final Class<?> type;

    KeyValuePreparedStatement(jakarta.nosql.keyvalue.KeyValuePreparedStatement preparedStatement, Class<?> type) {
        this.preparedStatement = preparedStatement;
        this.type = type;
    }

    public PreparedStatement bind(String name, Object value) {
        this.preparedStatement.bind(name, value);
        return this;
    }

    public <T> Stream<T> getResult() {
        Stream values = this.preparedStatement.getResult();
        Objects.requireNonNull(this.type, "type is required when the command returns value");
        return values.map(v -> v.get(this.type));
    }

    public <T> Optional<T> getSingleResult() {
        Optional singleResult = this.preparedStatement.getSingleResult();
        if (singleResult.isPresent()) {
            Objects.requireNonNull(this.type, "type is required when the command returns value");
            return singleResult.map(v -> v.get(this.type));
        }
        return Optional.empty();
    }
}

