/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.query;

import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplate;
import java.util.Optional;

public abstract class AbstractKeyValueRepository<T>
implements Repository {
    private final Class<T> typeClass;

    protected abstract KeyValueTemplate getTemplate();

    public AbstractKeyValueRepository(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public Object save(Object entity) {
        return this.getTemplate().put(entity);
    }

    public Iterable save(Iterable entities) {
        return this.getTemplate().put(entities);
    }

    public void deleteById(Object key) {
        this.getTemplate().delete(key);
    }

    public void deleteById(Iterable ids) {
        this.getTemplate().delete(ids);
    }

    public Optional findById(Object key) {
        return this.getTemplate().get(key, this.typeClass);
    }

    public Iterable findById(Iterable keys) {
        return this.getTemplate().get(keys, this.typeClass);
    }

    public boolean existsById(Object key) {
        return this.getTemplate().get(key, this.typeClass).isPresent();
    }

    public long count() {
        throw new UnsupportedOperationException("The key-value type does not support count method");
    }
}

