/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.query;

import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.keyvalue.KeyValueRepositoryProducer;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplate;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplateProducer;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.keyvalue.query.KeyValueRepositoryProxy;

@ApplicationScoped
class DefaultKeyValueRepositoryProducer
implements KeyValueRepositoryProducer {
    @Inject
    private KeyValueTemplateProducer producer;

    DefaultKeyValueRepositoryProducer() {
    }

    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, BucketManager manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        KeyValueTemplate template = this.producer.get(manager);
        return this.get(repositoryClass, template);
    }

    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, KeyValueTemplate template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        KeyValueRepositoryProxy handler = new KeyValueRepositoryProxy(repositoryClass, template);
        return (R)((Repository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

