/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.nosql.QueryMapper;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.communication.keyvalue.KeyValueEntity;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueEntityConverter;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueEventPersistManager;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueTemplate;

public abstract class AbstractKeyValueTemplate
implements KeyValueTemplate {
    protected abstract KeyValueEntityConverter getConverter();

    protected abstract BucketManager getManager();

    protected abstract KeyValueEventPersistManager getEventManager();

    @Override
    public <T> T put(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.persist(entity, keyValueEntity -> this.getManager().put(keyValueEntity));
    }

    @Override
    public <T> T put(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl class is required");
        return this.persist(entity, keyValueEntity -> this.getManager().put(keyValueEntity, ttl));
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        return this.put((T)entities);
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        return this.put((T)entities, ttl);
    }

    public <T> T update(T entity) {
        return this.put(entity);
    }

    public <T> Iterable<T> update(Iterable<T> entities) {
        return this.put((T)entities);
    }

    public <T> T insert(T entity) {
        return this.put(entity);
    }

    public <T> T insert(T entity, Duration ttl) {
        return this.put(entity, ttl);
    }

    @Override
    public <K, T> Optional<T> get(K key, Class<T> type) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(type, "entity class is required");
        Optional value = this.getManager().get(key);
        return value.map(v -> this.getConverter().toEntity(type, KeyValueEntity.of((Object)key, (Object)v))).filter(Objects::nonNull).map(e -> {
            this.getEventManager().firePostEntity(e);
            return e;
        });
    }

    @Override
    public <K, T> Iterable<T> get(Iterable<K> keys, Class<T> type) {
        Objects.requireNonNull(keys, "keys is required");
        Objects.requireNonNull(type, "type class is required");
        return StreamSupport.stream(keys.spliterator(), false).map(k -> this.getManager().get(k).map(v -> KeyValueEntity.of((Object)k, (Object)v))).filter(Optional::isPresent).map(e -> this.getConverter().toEntity(type, (KeyValueEntity)e.get())).collect(Collectors.toList());
    }

    @Override
    public <K> void delete(K key) {
        Objects.requireNonNull(key, "key is required");
        this.getManager().delete(key);
    }

    @Override
    public <K> void delete(Iterable<K> keys) {
        Objects.requireNonNull(keys, "keys is required");
        this.getManager().delete(keys);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        return this.get(id, type);
    }

    public <T, K> void delete(Class<T> type, K id) {
        this.delete(id);
    }

    public <T> QueryMapper.MapperFrom select(Class<T> type) {
        throw new UnsupportedOperationException("Key value database type does not have support for mapping query");
    }

    public <T> QueryMapper.MapperDeleteFrom delete(Class<T> type) {
        throw new UnsupportedOperationException("Key value database type does not have support for mapping query");
    }

    protected <T> T persist(T entity, Consumer<KeyValueEntity> persistAction) {
        return (T)Stream.of(entity).map(this.toUnary(this.getEventManager()::firePreEntity)).map(this.getConverter()::toKeyValue).map(this.toUnary(persistAction)).map(it -> this.getConverter().toEntity(entity.getClass(), (KeyValueEntity)it)).map(this.toUnary(this.getEventManager()::firePostEntity)).findFirst().orElseThrow();
    }

    private <T> UnaryOperator<T> toUnary(Consumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return t;
        };
    }
}

