/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.configuration;

import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.jnosql.communication.keyvalue.BucketManagerFactory;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueDatabase;

@ApplicationScoped
public class CollectionSupplier {
    @Inject
    private BucketManagerFactory factory;

    @Produces
    @KeyValueDatabase(value="")
    public <T> List<T> getList(InjectionPoint injectionPoint) {
        CollectionElement element = CollectionElement.of(injectionPoint);
        return this.factory.getList(element.bucketName, element.type);
    }

    @Produces
    @KeyValueDatabase(value="")
    public <T> Queue<T> getQueue(InjectionPoint injectionPoint) {
        CollectionElement element = CollectionElement.of(injectionPoint);
        return this.factory.getQueue(element.bucketName, element.type);
    }

    @Produces
    @KeyValueDatabase(value="")
    public <T> Set<T> getSet(InjectionPoint injectionPoint) {
        CollectionElement element = CollectionElement.of(injectionPoint);
        return this.factory.getSet(element.bucketName, element.type);
    }

    @Produces
    @KeyValueDatabase(value="")
    public <K, V> Map<K, V> getMap(InjectionPoint injectionPoint) {
        MapElement element = MapElement.of(injectionPoint);
        return this.factory.getMap(element.bucketName, element.key, element.value);
    }

    private record CollectionElement<T>(String bucketName, Class<T> type) {
        private static <T> CollectionElement<T> of(InjectionPoint injectionPoint) {
            KeyValueDatabase keyValue = injectionPoint.getQualifiers().stream().filter(KeyValueDatabase.class::isInstance).map(KeyValueDatabase.class::cast).findFirst().orElseThrow(() -> new MappingException("There is an issue to load a Collection from the database"));
            String bucketName = keyValue.value();
            Type type = injectionPoint.getType();
            if (type instanceof ParameterizedType) {
                ParameterizedType param = (ParameterizedType)type;
                Type argument = param.getActualTypeArguments()[0];
                return new CollectionElement<T>(bucketName, (Class)argument);
            }
            throw new MappingException("There is an issue to load a Collection from the database");
        }
    }

    private record MapElement<K, V>(String bucketName, Class<K> key, Class<V> value) {
        private static <K, V> MapElement<K, V> of(InjectionPoint injectionPoint) {
            KeyValueDatabase keyValue = injectionPoint.getQualifiers().stream().filter(KeyValueDatabase.class::isInstance).map(KeyValueDatabase.class::cast).findFirst().orElseThrow(() -> new MappingException("There is an issue to load a Collection from the database"));
            String bucketName = keyValue.value();
            Type type = injectionPoint.getType();
            if (type instanceof ParameterizedType) {
                ParameterizedType param = (ParameterizedType)type;
                Type key = param.getActualTypeArguments()[0];
                Type value = param.getActualTypeArguments()[1];
                return new MapElement<K, V>(bucketName, (Class)key, (Class)value);
            }
            throw new MappingException("There is an issue to load the Map from the database");
        }
    }
}

