/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.spi;

import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueTemplate;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueTemplateProducer;

class TemplateBean
extends AbstractBean<KeyValueTemplate> {
    private static final Set<Type> TYPES = Collections.singleton(KeyValueTemplate.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofKeyValue((String)provider));
    }

    public Class<?> getBeanClass() {
        return KeyValueTemplate.class;
    }

    public KeyValueTemplate create(CreationalContext<KeyValueTemplate> context) {
        KeyValueTemplateProducer producer = (KeyValueTemplateProducer)this.getInstance(KeyValueTemplateProducer.class);
        BucketManager manager = this.getManager();
        return producer.apply(manager);
    }

    private BucketManager getManager() {
        return (BucketManager)this.getInstance(BucketManager.class, (Annotation)DatabaseQualifier.ofKeyValue((String)this.provider));
    }

    public Set<Type> getTypes() {
        return TYPES;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return KeyValueTemplate.class.getName() + DatabaseType.KEY_VALUE + "-" + this.provider;
    }
}

