/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.configuration;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.keyvalue.BucketManagerFactory;
import org.eclipse.jnosql.communication.keyvalue.KeyValueConfiguration;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.core.config.MicroProfileSettings;
import org.eclipse.jnosql.mapping.reflection.Reflections;

@ApplicationScoped
class BucketManagerFactorySupplier
implements Supplier<BucketManagerFactory> {
    private static final Logger LOGGER = Logger.getLogger(BucketManagerFactorySupplier.class.getName());

    BucketManagerFactorySupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public BucketManagerFactory get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        KeyValueConfiguration configuration = settings.get((Supplier)MappingConfigurations.KEY_VALUE_PROVIDER, Class.class).filter(KeyValueConfiguration.class::isAssignableFrom).map(c -> {
            Reflections reflections = (Reflections)CDI.current().select(Reflections.class, new Annotation[0]).get();
            return (KeyValueConfiguration)Reflections.newInstance((Class)c);
        }).orElseGet(KeyValueConfiguration::getConfiguration);
        return (BucketManagerFactory)configuration.apply((Object)settings);
    }

    public void close(@Disposes BucketManagerFactory manager) {
        LOGGER.log(Level.FINEST, "Closing BucketManagerFactory");
        manager.close();
    }
}

