/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.query;

import java.lang.reflect.ParameterizedType;
import org.eclipse.jnosql.mapping.core.query.AbstractRepository;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueTemplate;
import org.eclipse.jnosql.mapping.keyvalue.query.AbstractKeyValueRepositoryProxy;
import org.eclipse.jnosql.mapping.keyvalue.query.DefaultKeyValueRepository;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

class KeyValueRepositoryProxy<T, K>
extends AbstractKeyValueRepositoryProxy<T, K> {
    private final DefaultKeyValueRepository<T, K> repository;
    private final KeyValueTemplate template;
    private final Class<T> type;
    private final Class<?> repositoryType;
    private final EntityMetadata metadata;

    KeyValueRepositoryProxy(Class<?> repositoryType, EntitiesMetadata entitiesMetadata, KeyValueTemplate template) {
        Class typeClass = (Class)((ParameterizedType)repositoryType.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.metadata = entitiesMetadata.get(typeClass);
        this.repository = new DefaultKeyValueRepository(this.metadata, template);
        this.template = template;
        this.type = typeClass;
        this.repositoryType = repositoryType;
    }

    protected AbstractRepository<T, K> repository() {
        return this.repository;
    }

    @Override
    protected KeyValueTemplate template() {
        return this.template;
    }

    @Override
    protected Class<T> type() {
        return this.type;
    }

    @Override
    protected Class<?> repositoryType() {
        return this.repositoryType;
    }

    protected EntityMetadata entityMetadata() {
        return this.metadata;
    }
}

