/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.NoSQLException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.AttributeConverter;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;
import org.eclipse.jnosql.mapping.reflection.Reflections;

abstract class AbstractFieldMetadata
implements FieldMetadata {
    protected final MappingType mappingType;
    protected final Field field;
    protected final String name;
    protected final String fieldName;
    protected final Class<? extends AttributeConverter<?, ?>> converter;
    protected final FieldReader reader;
    protected final FieldWriter writer;
    protected final Class<?> type;

    AbstractFieldMetadata(MappingType mappingType, Field field, String name, Class<? extends AttributeConverter<?, ?>> converter, FieldReader reader, FieldWriter writer) {
        this.mappingType = mappingType;
        this.field = field;
        this.name = name;
        this.fieldName = field.getName();
        this.converter = converter;
        this.reader = reader;
        this.writer = writer;
        this.type = field.getType();
    }

    public MappingType mappingType() {
        return this.mappingType;
    }

    public String name() {
        return this.name;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object read(Object bean) {
        Objects.requireNonNull(bean, "bean is required");
        return this.reader.read(bean);
    }

    public void write(Object bean, Object value) {
        Objects.requireNonNull(bean, "bean is required");
        this.writer.write(bean, value);
    }

    public Class<?> type() {
        return this.type;
    }

    public <X, Y, T extends AttributeConverter<X, Y>> Optional<Class<T>> converter() {
        return Optional.ofNullable(this.converter);
    }

    public <X, Y, T extends AttributeConverter<X, Y>> Optional<T> newConverter() {
        return Optional.ofNullable(this.converter).map(Reflections::newInstance);
    }

    public Object value(Value value) {
        return value.get(this.field.getType());
    }

    public <T extends Annotation> Optional<String> value(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        Optional<Method> method = Arrays.stream(type.getDeclaredMethods()).filter(m -> "value".equals(m.getName())).findFirst();
        Object annotation = this.field.getAnnotation(type);
        if (method.isEmpty() || annotation == null) {
            return Optional.empty();
        }
        return method.map(m -> {
            try {
                Object invoke = m.invoke(annotation, new Object[0]);
                return invoke.toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new NoSQLException("There is an issue invoking the method: " + m + " using the annotation: " + type, (Throwable)e);
            }
        });
    }
}

