/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;

public final class ConstructorEvent {
    private final Constructor<?> constructor;
    private final Object[] params;

    private ConstructorEvent(Constructor<?> constructor, Object[] params) {
        this.constructor = constructor;
        this.params = params;
    }

    public Constructor<?> constructor() {
        return this.constructor;
    }

    public Object[] params() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorEvent that = (ConstructorEvent)o;
        return Objects.equals(this.constructor, that.constructor) && Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.constructor) + Arrays.hashCode(this.params);
    }

    public String toString() {
        return "ConstructorEvent{constructor=" + this.constructor + ", params=" + Arrays.toString(this.params) + "}";
    }

    public static ConstructorEvent of(Constructor<?> constructor, Object[] params) {
        Objects.requireNonNull(constructor, "constructor is required");
        Objects.requireNonNull(params, "params is required");
        return new ConstructorEvent(constructor, params);
    }
}

