/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.mapping.AttributeConverter;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.AbstractFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;
import org.eclipse.jnosql.mapping.reflection.Reflections;

public class DefaultFieldMetadata
extends AbstractFieldMetadata {
    private final boolean id;

    DefaultFieldMetadata(MappingType type, Field field, String name, Class<? extends AttributeConverter<?, ?>> converter, boolean id, FieldReader reader, FieldWriter writer) {
        super(type, field, name, converter, reader, writer);
        this.id = id;
    }

    public boolean isId() {
        return this.id;
    }

    @Override
    public <X, Y, T extends AttributeConverter<X, Y>> Optional<T> newConverter() {
        return Optional.ofNullable((AttributeConverter)Reflections.newInstance(this.converter));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFieldMetadata that = (AbstractFieldMetadata)o;
        return this.mappingType == that.mappingType && Objects.equals(this.field, that.field) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.mappingType, this.field, this.name);
    }

    public String toString() {
        return "DefaultFieldMapping{id=" + this.id + ", type=" + this.mappingType + ", field=" + this.field + ", name='" + this.name + "', fieldName='" + this.fieldName + "', converter=" + this.converter + "}";
    }
}

