/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.Entity;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.ServiceLoader;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.AttributeConverter;
import org.eclipse.jnosql.mapping.Embeddable;
import org.eclipse.jnosql.mapping.metadata.CollectionSupplier;
import org.eclipse.jnosql.mapping.metadata.GenericFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.AbstractFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;

final class DefaultGenericFieldMetadata
extends AbstractFieldMetadata
implements GenericFieldMetadata {
    private final TypeSupplier<?> typeSupplier;

    DefaultGenericFieldMetadata(MappingType type, Field field, String name, TypeSupplier<?> typeSupplier, Class<? extends AttributeConverter<?, ?>> converter, FieldReader reader, FieldWriter writer) {
        super(type, field, name, converter, reader, writer);
        this.typeSupplier = typeSupplier;
    }

    @Override
    public Object value(Value value) {
        if (value.get() instanceof Iterable) {
            return value.get(this.typeSupplier);
        }
        return Value.of(Collections.singletonList(value.get())).get(this.typeSupplier);
    }

    public boolean isId() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGenericFieldMetadata that = (DefaultGenericFieldMetadata)o;
        return this.mappingType == that.mappingType && Objects.equals(this.field, that.field) && Objects.equals(this.typeSupplier, that.typeSupplier) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.mappingType, this.field, this.name, this.typeSupplier);
    }

    public boolean isEmbeddable() {
        return this.isEmbeddableField() || this.isEntityField();
    }

    private boolean isEntityField() {
        return this.hasFieldAnnotation(Entity.class);
    }

    private boolean isEmbeddableField() {
        return this.hasFieldAnnotation(Embeddable.class);
    }

    private boolean hasFieldAnnotation(Class<?> annotation) {
        return ((Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0]).getAnnotation(annotation) != null;
    }

    public Class<?> elementType() {
        return (Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
    }

    public Collection<?> collectionInstance() {
        Class<?> type = this.type();
        CollectionSupplier supplier = ServiceLoader.load(CollectionSupplier.class).stream().map(ServiceLoader.Provider::get).map(CollectionSupplier.class::cast).filter(c -> c.test((Object)type)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This collection is not supported yet: " + type));
        return (Collection)supplier.get();
    }

    public String toString() {
        return "GenericFieldMapping{typeSupplier=" + this.typeSupplier + ", type=" + this.mappingType + ", field=" + this.field + ", name='" + this.name + "', fieldName='" + this.fieldName + "', converter=" + this.converter + "}";
    }
}

