/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import java.lang.reflect.Field;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.mapping.AttributeConverter;
import org.eclipse.jnosql.mapping.metadata.GenericFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.DefaultFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.DefaultGenericFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.EmbeddedFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;

class FieldMappingBuilder {
    private MappingType type;
    private Field field;
    private String name;
    private String entityName;
    private TypeSupplier<?> typeSupplier;
    private Class<? extends AttributeConverter<?, ?>> converter;
    private boolean id;
    private FieldReader reader;
    private FieldWriter writer;

    FieldMappingBuilder() {
    }

    public FieldMappingBuilder withType(MappingType type) {
        this.type = type;
        return this;
    }

    public FieldMappingBuilder withField(Field field) {
        this.field = field;
        return this;
    }

    public FieldMappingBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public FieldMappingBuilder withTypeSupplier(TypeSupplier<?> typeSupplier) {
        this.typeSupplier = typeSupplier;
        return this;
    }

    public FieldMappingBuilder withEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public FieldMappingBuilder withConverter(Class<? extends AttributeConverter<?, ?>> converter) {
        this.converter = converter;
        return this;
    }

    public FieldMappingBuilder withId(boolean id) {
        this.id = id;
        return this;
    }

    public FieldMappingBuilder withWriter(FieldWriter writer) {
        this.writer = writer;
        return this;
    }

    public FieldMappingBuilder withReader(FieldReader reader) {
        this.reader = reader;
        return this;
    }

    public DefaultFieldMetadata buildDefault() {
        return new DefaultFieldMetadata(this.type, this.field, this.name, this.converter, this.id, this.reader, this.writer);
    }

    public GenericFieldMetadata buildGeneric() {
        return new DefaultGenericFieldMetadata(this.type, this.field, this.name, this.typeSupplier, this.converter, this.reader, this.writer);
    }

    public EmbeddedFieldMetadata buildEmbedded() {
        return new EmbeddedFieldMetadata(this.type, this.field, this.name, this.entityName, this.reader, this.writer);
    }
}

