/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import jakarta.data.repository.BasicRepository;
import jakarta.data.repository.CrudRepository;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Repository;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jnosql.mapping.NoSQLRepository;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;
import org.eclipse.jnosql.mapping.reflection.RepositoryFilter;

enum ClassGraphClassScanner implements ClassScanner
{
    INSTANCE;

    private final Set<Class<?>> entities = new HashSet();
    private final Set<Class<?>> repositories;
    private final Set<Class<?>> embeddables = new HashSet();
    private final Set<Class<?>> customRepositories;

    private ClassGraphClassScanner() {
        this.repositories = new HashSet();
        this.customRepositories = new HashSet();
        Logger logger = Logger.getLogger(ClassGraphClassScanner.class.getName());
        logger.fine("Starting scan class to find entities, embeddable and repositories.");
        try (ScanResult result = new ClassGraph().enableAllInfo().scan();){
            List<Class<DataRepository>> notSupportedRepositories = ClassGraphClassScanner.loadNotSupportedRepositories(result);
            logger.info("The following repositories are not supported: " + notSupportedRepositories);
            this.entities.addAll(ClassGraphClassScanner.loadEntities(result));
            this.embeddables.addAll(ClassGraphClassScanner.loadEmbeddable(result));
            this.repositories.addAll(ClassGraphClassScanner.loadRepositories(result));
            this.customRepositories.addAll(ClassGraphClassScanner.loadCustomRepositories(result));
            notSupportedRepositories.forEach(this.repositories::remove);
        }
        logger.fine(String.format("Finished the class scan with entities %d, embeddables %d and repositories: %d", this.entities.size(), this.embeddables.size(), this.repositories.size()));
    }

    public Set<Class<?>> entities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public Set<Class<?>> repositories() {
        return Collections.unmodifiableSet(this.repositories);
    }

    public Set<Class<?>> embeddables() {
        return Collections.unmodifiableSet(this.embeddables);
    }

    public <T extends DataRepository<?, ?>> Set<Class<?>> repositories(Class<T> filter) {
        Objects.requireNonNull(filter, "filter is required");
        return this.repositories.stream().filter(filter::isAssignableFrom).filter(c -> Arrays.asList(c.getInterfaces()).contains(filter)).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Class<?>> repositoriesStandard() {
        return this.repositories.stream().filter(c -> {
            List<Class<?>> interfaces = Arrays.asList(c.getInterfaces());
            return interfaces.contains(CrudRepository.class) || interfaces.contains(BasicRepository.class) || interfaces.contains(NoSQLRepository.class) || interfaces.contains(DataRepository.class);
        }).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Class<?>> customRepositories() {
        return this.customRepositories;
    }

    private static List<Class<DataRepository>> loadRepositories(ScanResult scan) {
        return scan.getClassesWithAnnotation(Repository.class).getInterfaces().filter(c -> c.implementsInterface(DataRepository.class)).loadClasses(DataRepository.class).stream().filter(RepositoryFilter.INSTANCE).toList();
    }

    private static List<Class<?>> loadCustomRepositories(ScanResult scan) {
        return scan.getClassesWithAnnotation(Repository.class).getInterfaces().filter(c -> !c.implementsInterface(DataRepository.class)).loadClasses().stream().toList();
    }

    private static List<Class<DataRepository>> loadNotSupportedRepositories(ScanResult scan) {
        return scan.getClassesWithAnnotation(Repository.class).getInterfaces().filter(c -> c.implementsInterface(DataRepository.class)).loadClasses(DataRepository.class).stream().filter(Predicate.not(RepositoryFilter.INSTANCE)).toList();
    }

    private static List<Class<?>> loadEmbeddable(ScanResult scan) {
        return scan.getClassesWithAnnotation(Embeddable.class).loadClasses();
    }

    private static List<Class<?>> loadEntities(ScanResult scan) {
        return scan.getClassesWithAnnotation(Entity.class).loadClasses();
    }
}

