/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.AttributeConverter;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.mapping.metadata.CollectionParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.CollectionSupplier;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.DefaultParameterMetaData;

class DefaultCollectionParameterMetaData
extends DefaultParameterMetaData
implements CollectionParameterMetaData {
    private static final List<CollectionSupplier> COLLECTION_SUPPLIERS = ServiceLoader.load(CollectionSupplier.class).stream().map(ServiceLoader.Provider::get).toList();
    private final Class<?> elementType;
    private final boolean embeddableField;

    DefaultCollectionParameterMetaData(String name, Class<?> type, boolean id, Class<? extends AttributeConverter<?, ?>> converter, MappingType mappingType, TypeSupplier<?> typeSupplier) {
        super(name, type, id, converter, mappingType);
        this.elementType = (Class)((ParameterizedType)typeSupplier.get()).getActualTypeArguments()[0];
        this.embeddableField = this.hasFieldAnnotation(Embeddable.class) || this.hasFieldAnnotation(Entity.class);
    }

    public boolean isEmbeddable() {
        return this.embeddableField;
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public Collection<?> collectionInstance() {
        Class<?> type = this.type();
        CollectionSupplier supplier = COLLECTION_SUPPLIERS.stream().filter(c -> c.test((Object)type)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This collection is not supported yet: " + type));
        return (Collection)supplier.get();
    }

    private boolean hasFieldAnnotation(Class<? extends Annotation> annotation) {
        return this.elementType.getAnnotation(annotation) != null;
    }
}

