/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.mapping.metadata.ConstructorBuilder;
import org.eclipse.jnosql.mapping.metadata.ConstructorMetadata;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;
import org.eclipse.jnosql.mapping.reflection.ConstructorEvent;
import org.eclipse.jnosql.mapping.reflection.DefaultConstructorMetadata;

final class DefaultConstructorBuilder
implements ConstructorBuilder {
    private final List<Object> values = new ArrayList<Object>();
    private final ConstructorMetadata metadata;

    private DefaultConstructorBuilder(ConstructorMetadata metadata) {
        this.metadata = metadata;
    }

    public List<ParameterMetaData> parameters() {
        return this.metadata.parameters();
    }

    public void add(Object value) {
        this.values.add(value);
    }

    public void addEmptyParameter() {
        Constructor<?> constructor = ((DefaultConstructorMetadata)this.metadata).constructor();
        Class<?> type = constructor.getParameterTypes()[this.values.size()];
        if (Boolean.TYPE.equals(type)) {
            this.values.add(Boolean.FALSE);
        } else if (Character.TYPE.equals(type)) {
            this.values.add(Character.valueOf('\u0000'));
        } else if (type.isPrimitive()) {
            this.values.add((byte)0);
        } else {
            this.values.add(null);
        }
    }

    public <T> T build() {
        Constructor<?> constructor = ((DefaultConstructorMetadata)this.metadata).constructor();
        try {
            Instance instance = CDI.current().select((TypeLiteral)new TypeLiteral<Event<ConstructorEvent>>(){}, new Annotation[0]);
            Event event = (Event)instance.get();
            event.fire((Object)ConstructorEvent.of(constructor, this.values.toArray()));
            return (T)constructor.newInstance(this.values.toArray());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new MappingException("There is an issue to create a new instance of this class using this constructor: " + constructor, (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConstructorBuilder that = (DefaultConstructorBuilder)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.metadata);
    }

    public String toString() {
        return "ConstructorBuilder{values=" + this.values + ", metadata=" + this.metadata + "}";
    }

    static ConstructorBuilder of(ConstructorMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata is required");
        return new DefaultConstructorBuilder(metadata);
    }
}

