/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.AttributeConverter;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.metadata.MapFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.AbstractFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;
import org.eclipse.jnosql.mapping.reflection.Reflections;

final class DefaultMapFieldMetadata
extends AbstractFieldMetadata
implements MapFieldMetadata {
    private final TypeSupplier<?> typeSupplier;
    private final Class<?> keyType;
    private final Class<?> valueType;
    private final boolean embeddableField;

    DefaultMapFieldMetadata(MappingType type, Field field, String name, TypeSupplier<?> typeSupplier, Class<? extends AttributeConverter<?, ?>> converter, FieldReader reader, FieldWriter writer, String udt) {
        super(type, field, name, converter, reader, writer, udt);
        this.typeSupplier = typeSupplier;
        ParameterizedType mapType = Reflections.findParameterizedType(this.field.getGenericType(), Map.class).orElseThrow(() -> new IllegalStateException(MessageFormat.format("Unable to find parameterized Map implementation for {0}", this.field)));
        this.keyType = (Class)mapType.getActualTypeArguments()[0];
        this.valueType = (Class)mapType.getActualTypeArguments()[1];
        this.embeddableField = this.hasFieldAnnotation(Embeddable.class) || this.hasFieldAnnotation(Entity.class);
    }

    @Override
    public Object value(Value value) {
        return value.get(this.typeSupplier);
    }

    public boolean isId() {
        return false;
    }

    public boolean isEmbeddable() {
        return this.embeddableField;
    }

    public Class<?> keyType() {
        return this.keyType;
    }

    public Class<?> valueType() {
        return this.valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMapFieldMetadata that = (DefaultMapFieldMetadata)o;
        return Objects.equals(this.typeSupplier, that.typeSupplier) && Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.typeSupplier, this.keyType, this.valueType);
    }

    private boolean hasFieldAnnotation(Class<? extends Annotation> annotation) {
        return this.valueType.getAnnotation(annotation) != null;
    }
}

