/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jnosql.mapping.metadata.ClassConverter;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.GroupEntityMetadata;

@ApplicationScoped
public class ReflectionGroupEntityMetadata
implements GroupEntityMetadata {
    private final Map<Class<?>, EntityMetadata> classes = new ConcurrentHashMap();
    private final Map<String, EntityMetadata> mappings = new ConcurrentHashMap<String, EntityMetadata>();

    @PostConstruct
    public void postConstruct() {
        EntityMetadata entityMetadata;
        ClassConverter converter = ClassConverter.load();
        ClassScanner scanner = ClassScanner.load();
        for (Class entity : scanner.entities()) {
            entityMetadata = (EntityMetadata)converter.apply((Object)entity);
            if (entityMetadata.hasEntityName()) {
                this.mappings.put(entityMetadata.name(), entityMetadata);
            }
            this.classes.put(entity, entityMetadata);
        }
        for (Class embeddable : scanner.embeddables()) {
            entityMetadata = (EntityMetadata)converter.apply((Object)embeddable);
            this.classes.put(embeddable, entityMetadata);
        }
    }

    public Map<String, EntityMetadata> mappings() {
        return this.mappings;
    }

    public Map<Class<?>, EntityMetadata> classes() {
        return this.classes;
    }
}

