/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import jakarta.nosql.AttributeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.DefaultFieldValue;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldValue;
import org.eclipse.jnosql.mapping.metadata.GenericFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.semistructured.AttributeFieldValue;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;

final class DefaultAttributeFieldValue
implements AttributeFieldValue {
    private final FieldValue fieldValue;

    private DefaultAttributeFieldValue(FieldValue fieldValue) {
        this.fieldValue = fieldValue;
    }

    public Object value() {
        return this.fieldValue.value();
    }

    public FieldMetadata field() {
        return this.fieldValue.field();
    }

    public boolean isNotEmpty() {
        return this.fieldValue.isNotEmpty();
    }

    @Override
    public <X, Y> List<Element> toElements(EntityConverter converter, Converters converters) {
        if (this.value() == null) {
            return Collections.singletonList(Element.of((String)this.getName(), null));
        }
        if (MappingType.EMBEDDED.equals((Object)this.getType())) {
            return converter.toCommunication(this.value()).elements();
        }
        if (MappingType.ENTITY.equals((Object)this.getType()) || MappingType.EMBEDDED_GROUP.equals((Object)this.getType())) {
            return Collections.singletonList(Element.of((String)this.getName(), (Object)converter.toCommunication(this.value()).elements()));
        }
        if (this.isEmbeddableCollection()) {
            return Collections.singletonList(Element.of((String)this.getName(), this.getColumns(converter)));
        }
        Optional optionalConverter = this.field().converter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((FieldParameterMetadata)this.field());
            return Collections.singletonList(Element.of((String)this.getName(), (Object)attributeConverter.convertToDatabaseColumn(this.value())));
        }
        return Collections.singletonList(Element.of((String)this.getName(), (Object)this.value()));
    }

    private List<List<Element>> getColumns(EntityConverter converter) {
        ArrayList<List<Element>> columns = new ArrayList<List<Element>>();
        for (Object element : (Iterable)this.value()) {
            columns.add(converter.toCommunication(element).elements());
        }
        return columns;
    }

    private boolean isEmbeddableCollection() {
        return MappingType.COLLECTION.equals((Object)this.getType()) && this.isEmbeddableElement();
    }

    private MappingType getType() {
        return this.field().mappingType();
    }

    private String getName() {
        return this.field().name();
    }

    private boolean isEmbeddableElement() {
        return ((GenericFieldMetadata)this.field()).isEmbeddable();
    }

    public String toString() {
        return "ColumnFieldValue{fieldValue=" + this.fieldValue + "}";
    }

    static AttributeFieldValue of(Object value, FieldMetadata field) {
        return new DefaultAttributeFieldValue((FieldValue)new DefaultFieldValue(value, field));
    }
}

