/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.PageRequest;
import jakarta.data.page.impl.CursoredPageRecord;
import jakarta.nosql.QueryMapper;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.QueryParser;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.mapping.IdNotFoundException;
import org.eclipse.jnosql.mapping.PreparedStatement;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.util.ConverterUtil;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;
import org.eclipse.jnosql.mapping.semistructured.EventPersistManager;
import org.eclipse.jnosql.mapping.semistructured.MapperDelete;
import org.eclipse.jnosql.mapping.semistructured.MapperObserver;
import org.eclipse.jnosql.mapping.semistructured.MapperSelect;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;

public abstract class AbstractSemiStructuredTemplate
implements SemiStructuredTemplate {
    private static final QueryParser PARSER = new QueryParser();
    private final UnaryOperator<CommunicationEntity> insert = e -> this.manager().insert(e);
    private final UnaryOperator<CommunicationEntity> update = e -> this.manager().update(e);
    private CommunicationObserverParser observer;

    protected abstract EntityConverter converter();

    protected abstract DatabaseManager manager();

    protected abstract EventPersistManager eventManager();

    protected abstract EntitiesMetadata entities();

    protected abstract Converters converters();

    private CommunicationObserverParser getObserver() {
        if (Objects.isNull(this.observer)) {
            this.observer = new MapperObserver(this.entities());
        }
        return this.observer;
    }

    public <T> T insert(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.persist(entity, this.insert);
    }

    public <T> T insert(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return this.persist(entity, e -> this.manager().insert(e, ttl));
    }

    public <T> T update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.persist(entity, this.update);
    }

    public <T> Iterable<T> update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entity is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(e -> this.insert(e, ttl)).collect(Collectors.toList());
    }

    @Override
    public void delete(DeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.manager().delete(query);
    }

    @Override
    public <T> Stream<T> select(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.executeQuery(query);
    }

    @Override
    public long count(SelectQuery query) {
        return this.manager().count(query);
    }

    @Override
    public boolean exists(SelectQuery query) {
        return this.manager().exists(query);
    }

    @Override
    public <T> Optional<T> singleResult(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> select = this.select(query);
        Iterator iterator = select.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No Unique result found to the query: " + query);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.entities().get(type);
        FieldMetadata idField = (FieldMetadata)entityMetadata.id().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.fieldName(), (Converters)this.converters());
        SelectQuery query = SelectQuery.select().from(entityMetadata.name()).where(idField.name()).eq(value).build();
        return this.singleResult(query);
    }

    public <T, K> void delete(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.entities().get(type);
        FieldMetadata idField = (FieldMetadata)entityMetadata.id().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.fieldName(), (Converters)this.converters());
        DeleteQuery query = DeleteQuery.delete().from(entityMetadata.name()).where(idField.name()).eq(value).build();
        this.manager().delete(query);
    }

    @Override
    public <T> Stream<T> query(String query) {
        Objects.requireNonNull(query, "query is required");
        return PARSER.query(query, null, this.manager(), this.getObserver()).map(c -> this.converter().toEntity((CommunicationEntity)c));
    }

    @Override
    public <T> Stream<T> query(String query, String entity) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(entity, "entity is required");
        return PARSER.query(query, entity, this.manager(), this.getObserver()).map(c -> this.converter().toEntity((CommunicationEntity)c));
    }

    @Override
    public <T> Optional<T> singleResult(String query) {
        Stream<T> entities = this.query(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    @Override
    public <T> Optional<T> singleResult(String query, String entityName) {
        Stream<T> entities = this.query(query, entityName);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    @Override
    public PreparedStatement prepare(String query) {
        return new org.eclipse.jnosql.mapping.semistructured.PreparedStatement(PARSER.prepare(query, null, this.manager(), this.getObserver()), this.converter());
    }

    @Override
    public PreparedStatement prepare(String query, String entity) {
        return new org.eclipse.jnosql.mapping.semistructured.PreparedStatement(PARSER.prepare(query, entity, this.manager(), this.getObserver()), this.converter());
    }

    @Override
    public long count(String columnFamily) {
        return this.manager().count(columnFamily);
    }

    @Override
    public <T> long count(Class<T> type) {
        Objects.requireNonNull(type, "entity class is required");
        return this.manager().count(this.findAllQuery(type));
    }

    private <T> Stream<T> executeQuery(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream entities = this.manager().select(query);
        Function<CommunicationEntity, Object> function = e -> this.converter().toEntity((CommunicationEntity)e);
        return entities.map(function).peek(this.eventManager()::firePostEntity);
    }

    public <T> QueryMapper.MapperFrom select(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.entities().get(type);
        return new MapperSelect(metadata, this.converters(), this);
    }

    public <T> QueryMapper.MapperDeleteFrom delete(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.entities().get(type);
        return new MapperDelete(metadata, this.converters(), this);
    }

    @Override
    public <T> Stream<T> findAll(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        return this.select(this.findAllQuery(type));
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        InheritanceMetadata inheritanceMetadata;
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.entities().get(type);
        if (metadata.inheritance().isPresent() && !(inheritanceMetadata = (InheritanceMetadata)metadata.inheritance().orElseThrow()).parent().equals(metadata.type())) {
            this.manager().delete(DeleteQuery.delete().from(metadata.name()).where(inheritanceMetadata.discriminatorColumn()).eq((Object)inheritanceMetadata.discriminatorValue()).build());
            return;
        }
        this.manager().delete(DeleteQuery.delete().from(metadata.name()).build());
    }

    @Override
    public <T> CursoredPage<T> selectCursor(SelectQuery query, PageRequest pageRequest) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(pageRequest, "pageRequest is required");
        CursoredPage cursoredPage = this.manager().selectCursor(query, pageRequest);
        List<Object> entities = cursoredPage.stream().map(c -> this.converter().toEntity((CommunicationEntity)c)).toList();
        PageRequest nextPageRequest = cursoredPage.hasNext() ? cursoredPage.nextPageRequest() : null;
        PageRequest beforePageRequest = cursoredPage.hasPrevious() ? cursoredPage.previousPageRequest() : null;
        List cursors = ((CursoredPageRecord)cursoredPage).cursors();
        return new CursoredPageRecord(entities, cursors, -1L, pageRequest, nextPageRequest, beforePageRequest);
    }

    protected <T> T persist(T entity, UnaryOperator<CommunicationEntity> persistAction) {
        return (T)Stream.of(entity).map(this.toUnary(this.eventManager()::firePreEntity)).map(this.converter()::toCommunication).map(persistAction).map(t -> this.converter().toEntity(entity, (CommunicationEntity)t)).map(this.toUnary(this.eventManager()::firePostEntity)).findFirst().orElseThrow();
    }

    private <T> UnaryOperator<T> toUnary(Consumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return t;
        };
    }

    private <T> SelectQuery findAllQuery(Class<T> type) {
        InheritanceMetadata inheritanceMetadata;
        EntityMetadata metadata = this.entities().get(type);
        if (metadata.inheritance().isPresent() && !(inheritanceMetadata = (InheritanceMetadata)metadata.inheritance().orElseThrow()).parent().equals(metadata.type())) {
            return SelectQuery.select().from(metadata.name()).where(inheritanceMetadata.discriminatorColumn()).eq((Object)inheritanceMetadata.discriminatorValue()).build();
        }
        return SelectQuery.select().from(metadata.name()).build();
    }
}

