/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import java.util.Optional;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.mapping.metadata.ClassInformationNotFoundException;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

final class MapperObserver
implements CommunicationObserverParser {
    private final EntitiesMetadata mappings;

    MapperObserver(EntitiesMetadata mappings) {
        this.mappings = mappings;
    }

    public String fireEntity(String entity) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(EntityMetadata::name).orElse(entity);
    }

    public String fireField(String entity, String field) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(c -> c.columnField(field)).orElse(field);
    }

    private Optional<EntityMetadata> getEntityMetadata(String entity) {
        try {
            return Optional.of(this.mappings.findByName(entity));
        }
        catch (ClassInformationNotFoundException e) {
            return this.mappings.findBySimpleName(entity).or(() -> this.mappings.findByClassName(entity));
        }
    }
}

