/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.data.Order;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.mapping.core.NoSQLPage;
import org.eclipse.jnosql.mapping.core.query.AbstractRepository;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.MappingQuery;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;

public abstract class AbstractSemiStructuredRepository<T, K>
extends AbstractRepository<T, K> {
    protected abstract SemiStructuredTemplate template();

    public long countBy() {
        return this.template().count(this.type());
    }

    public Page<T> findAll(PageRequest pageRequest, Order<T> order) {
        Objects.requireNonNull(pageRequest, "pageRequest is required");
        EntityMetadata metadata = this.entityMetadata();
        ArrayList sorts = new ArrayList();
        order.forEach(sorts::add);
        MappingQuery query = new MappingQuery(sorts, pageRequest.size(), NoSQLPage.skip((PageRequest)pageRequest), null, metadata.name());
        List entities = this.template().select(query).toList();
        return NoSQLPage.of(entities, (PageRequest)pageRequest);
    }

    public Stream<T> findAll() {
        return this.template().findAll(this.type());
    }

    public void deleteAll() {
        this.template().deleteAll(this.type());
    }
}

