/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import jakarta.nosql.AttributeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.metadata.ArrayFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.CollectionFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.MapFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum FieldConverter {
    EMBEDDED{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> elements, Element element, FieldMetadata field, EntityConverter converter) {
            Object subEntity = converter.toEntity(field.type(), elements);
            EntityMetadata mapping = converter.entities().get(subEntity.getClass());
            boolean areAllFieldsNull = mapping.fields().stream().map(f -> f.read(subEntity)).allMatch(Objects::isNull);
            if (!areAllFieldsNull) {
                field.write(instance, subEntity);
            }
        }
    }
    ,
    ENTITY{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> elements, Element subElement, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(subElement)) {
                this.converterSubDocument(instance, subElement, field, converter);
            } else {
                field.write(instance, converter.toEntity(field.type(), elements));
            }
        }

        private <T> void converterSubDocument(T instance, Element subElement, FieldMetadata field, EntityConverter converter) {
            Object value = subElement.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Element> embeddedColumns = new ArrayList<Element>();
                for (Map.Entry entry : map.entrySet()) {
                    embeddedColumns.add(Element.of((String)entry.getKey().toString(), entry.getValue()));
                }
                field.write(instance, converter.toEntity(field.type(), embeddedColumns));
            } else {
                field.write(instance, converter.toEntity(field.type(), (List)subElement.get((TypeSupplier)new TypeReference<List<Element>>(){})));
            }
        }
    }
    ,
    COLLECTION{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> columns, Element element, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(element)) {
                Collection elements;
                CollectionFieldMetadata collectionFieldMetadata = (CollectionFieldMetadata)field;
                Class type = collectionFieldMetadata.elementType();
                if (FieldConverter.feedEmbeddedList(element, converter, type, elements = collectionFieldMetadata.collectionInstance())) {
                    return;
                }
                field.write(instance, (Object)elements);
            }
        }
    }
    ,
    ARRAY{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> columns, Element element, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(element)) {
                ArrayFieldMetadata arrayFieldMetadata = (ArrayFieldMetadata)field;
                if (arrayFieldMetadata.isEmbeddable()) {
                    ArrayList elements;
                    Class type = arrayFieldMetadata.elementType();
                    if (FieldConverter.feedEmbeddedList(element, converter, type, elements = new ArrayList())) {
                        return;
                    }
                    Object array = arrayFieldMetadata.arrayInstance(elements);
                    field.write(instance, array);
                } else {
                    this.executeNoEmbeddableField(instance, element, field, arrayFieldMetadata);
                }
            }
        }

        private <X, Y, T> void executeNoEmbeddableField(T instance, Element element, FieldMetadata field, ArrayFieldMetadata arrayFieldMetadata) {
            ArrayList<Object> elements = new ArrayList<Object>();
            Object value = element.get();
            if (value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                this.executeIterable(arrayFieldMetadata, iterable, elements);
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                this.executeIterable(arrayFieldMetadata, Arrays.asList(objects), elements);
            } else {
                if (value.getClass().isArray()) {
                    field.write(instance, value);
                    return;
                }
                this.executeIterable(arrayFieldMetadata, Collections.singletonList(value), elements);
            }
            Object array = arrayFieldMetadata.arrayInstance(elements);
            field.write(instance, array);
        }

        private <X, Y> void executeIterable(ArrayFieldMetadata arrayFieldMetadata, Iterable<?> iterable, List<Object> elements) {
            for (Object item : iterable) {
                elements.add(Value.of(item).get(arrayFieldMetadata.elementType()));
            }
        }
    }
    ,
    MAP{

        @Override
        <X, Y, T> void convert(T instance, List<Element> elements, Element element, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(element)) {
                MapFieldMetadata mapFieldMetadata = (MapFieldMetadata)field;
                Object value = mapFieldMetadata.value(element.value());
                Optional optionalConverter = field.converter();
                if (mapFieldMetadata.isEmbeddable()) {
                    5.executeEmbeddableMap(instance, field, mapFieldMetadata, (Map)value, converter);
                } else if (optionalConverter.isPresent()) {
                    AttributeConverter attributeConverter = converter.converters().get((FieldParameterMetadata)field);
                    Object attributeConverted = attributeConverter.convertToEntityAttribute(value);
                    field.write(instance, attributeConverted);
                } else {
                    field.write(instance, value);
                }
            }
        }

        private static <Y, T> void executeEmbeddableMap(T instance, FieldMetadata field, MapFieldMetadata mapFieldMetadata, Map<?, ?> value, EntityConverter converter) {
            HashMap<String, Object> mapEntity = new HashMap<String, Object>();
            Class type = mapFieldMetadata.valueType();
            for (Object key : value.keySet()) {
                Object document = value.get(key);
                if (document instanceof Map) {
                    Map map = (Map)document;
                    Object entity = 5.getEntity(converter, map, type);
                    mapEntity.put(key.toString(), entity);
                    continue;
                }
                throw new IllegalStateException("Invalid map value type: expected a basic attribute, or a type annotated with @Entity or @Embeddable from jakarta.nosql, but found: " + mapFieldMetadata.valueType());
            }
            field.write(instance, mapEntity);
        }

        private static Object getEntity(EntityConverter converter, Map map, Class<?> type) {
            ArrayList<Element> embeddedColumns = new ArrayList<Element>();
            for (Map.Entry entry : map.entrySet()) {
                embeddedColumns.add(Element.of((String)entry.getKey().toString(), entry.getValue()));
            }
            return converter.toEntity(type, embeddedColumns);
        }
    }
    ,
    DEFAULT{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> elements, Element element, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(element)) {
                Value value = element.value();
                Optional optionalConverter = field.converter();
                if (optionalConverter.isPresent()) {
                    this.executeConverter(instance, element, field, converter, value);
                } else {
                    field.write(instance, field.value(value));
                }
            }
        }

        <X, Y, T> void executeConverter(T instance, Element element, FieldMetadata field, EntityConverter converter, Value value) {
            Object attr;
            AttributeConverter attributeConverter = converter.converters().get((FieldParameterMetadata)field);
            Object object = attr = value.isInstanceOf(List.class) ? element : value.get();
            if (this.isElement(attr)) {
                Map mapValue = (Map)value.get((TypeSupplier)new TypeReference<Map<String, Object>>(){});
                Object attributeConverted = attributeConverter.convertToEntityAttribute((Object)mapValue);
                field.write(instance, field.value(Value.of((Object)attributeConverted)));
            } else {
                Object attributeConverted = attributeConverter.convertToEntityAttribute(attr);
                field.write(instance, field.value(Value.of((Object)attributeConverted)));
            }
        }
    };


    private static boolean feedEmbeddedList(Element element, EntityConverter converter, Class<?> type, Collection elements) {
        List embeddable = (List)element.get();
        if (Objects.isNull(embeddable)) {
            return true;
        }
        for (List elementList : embeddable) {
            Object item = converter.toEntity(type, elementList);
            elements.add(item);
        }
        return false;
    }

    <Y> boolean isElement(Y attr) {
        return attr instanceof Element;
    }

    static FieldConverter get(FieldMetadata field) {
        if (MappingType.EMBEDDED.equals((Object)field.mappingType())) {
            return EMBEDDED;
        }
        if (MappingType.ENTITY.equals((Object)field.mappingType()) || MappingType.EMBEDDED_GROUP.equals((Object)field.mappingType())) {
            return ENTITY;
        }
        if (FieldConverter.isCollectionEmbeddable(field)) {
            return COLLECTION;
        }
        if (MappingType.MAP.equals((Object)field.mappingType())) {
            return MAP;
        }
        if (MappingType.ARRAY.equals((Object)field.mappingType())) {
            return ARRAY;
        }
        return DEFAULT;
    }

    private static boolean isCollectionEmbeddable(FieldMetadata field) {
        return MappingType.COLLECTION.equals((Object)field.mappingType()) && ((CollectionFieldMetadata)field).isEmbeddable();
    }

    abstract <X, Y, T> void convert(T var1, List<Element> var2, Element var3, FieldMetadata var4, EntityConverter var5);

    <X, Y, T> void convert(T instance, Element element, FieldMetadata field, EntityConverter converter) {
        this.convert(instance, null, element, field, converter);
    }
}

