/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.eclipse.jnosql.mapping.core.util.AnnotationLiteralUtil;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;

abstract class BaseRepositoryBean<T>
extends AbstractBean<T> {
    private final Class<T> type;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;
    private final DatabaseType databaseType;

    protected BaseRepositoryBean(Class<?> type, String provider, DatabaseType databaseType) {
        this.type = type;
        this.types = Collections.singleton(type);
        this.provider = provider;
        this.databaseType = databaseType;
        this.qualifiers = this.initializeQualifiers();
    }

    private Set<Annotation> initializeQualifiers() {
        if (this.provider.isEmpty()) {
            HashSet<Annotation> defaultQualifiers = new HashSet<Annotation>();
            defaultQualifiers.add((Annotation)this.getDatabaseQualifier());
            defaultQualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
            defaultQualifiers.add((Annotation)AnnotationLiteralUtil.ANY_ANNOTATION);
            return defaultQualifiers;
        }
        return Collections.singleton(this.getDatabaseQualifier(this.provider));
    }

    protected abstract Class<? extends SemiStructuredTemplate> getTemplateClass();

    private DatabaseQualifier getDatabaseQualifier() {
        return switch (this.databaseType) {
            case DatabaseType.COLUMN -> DatabaseQualifier.ofColumn();
            case DatabaseType.DOCUMENT -> DatabaseQualifier.ofDocument();
            case DatabaseType.GRAPH -> DatabaseQualifier.ofGraph();
            default -> throw new IllegalArgumentException("Unsupported database type: " + this.databaseType);
        };
    }

    private DatabaseQualifier getDatabaseQualifier(String provider) {
        return switch (this.databaseType) {
            case DatabaseType.COLUMN -> DatabaseQualifier.ofColumn((String)provider);
            case DatabaseType.DOCUMENT -> DatabaseQualifier.ofDocument((String)provider);
            case DatabaseType.GRAPH -> DatabaseQualifier.ofGraph((String)provider);
            default -> throw new IllegalArgumentException("Unsupported database type: " + this.databaseType);
        };
    }

    protected abstract InvocationHandler createHandler(EntitiesMetadata var1, SemiStructuredTemplate var2, Converters var3);

    public Class<?> getBeanClass() {
        return this.type;
    }

    public T create(CreationalContext<T> context) {
        EntitiesMetadata entities = (EntitiesMetadata)this.getInstance(EntitiesMetadata.class);
        SemiStructuredTemplate template = this.provider.isEmpty() ? (SemiStructuredTemplate)this.getInstance(this.getTemplateClass()) : (SemiStructuredTemplate)this.getInstance(this.getTemplateClass(), (Annotation)this.getDatabaseQualifier(this.provider));
        Converters converters = (Converters)this.getInstance(Converters.class);
        InvocationHandler handler = this.createHandler(entities, template, converters);
        return (T)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@" + this.databaseType + "-" + this.provider;
    }
}

