/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import jakarta.nosql.AttributeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.ArrayFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.CollectionFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.DefaultFieldValue;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldValue;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.semistructured.AttributeFieldValue;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;

final class DefaultAttributeFieldValue
implements AttributeFieldValue {
    private final FieldValue fieldValue;

    private DefaultAttributeFieldValue(FieldValue fieldValue) {
        this.fieldValue = fieldValue;
    }

    public Object value() {
        return this.fieldValue.value();
    }

    public FieldMetadata field() {
        return this.fieldValue.field();
    }

    public boolean isNotEmpty() {
        return this.fieldValue.isNotEmpty();
    }

    @Override
    public <X, Y> List<Element> toElements(EntityConverter converter, Converters converters) {
        if (this.value() == null) {
            return Collections.singletonList(Element.of((String)this.name(), null));
        }
        if (MappingType.EMBEDDED.equals((Object)this.type())) {
            return converter.toCommunication(this.value()).elements();
        }
        if (MappingType.ENTITY.equals((Object)this.type()) || MappingType.EMBEDDED_GROUP.equals((Object)this.type())) {
            return Collections.singletonList(Element.of((String)this.name(), (Object)converter.toCommunication(this.value()).elements()));
        }
        if (this.isEmbeddableCollection()) {
            return Collections.singletonList(Element.of((String)this.name(), this.columns(converter)));
        }
        if (this.isEmbeddableArray()) {
            return Collections.singletonList(Element.of((String)this.name(), this.columnsToArray(converter)));
        }
        if (MappingType.ARRAY.equals((Object)this.type())) {
            return Collections.singletonList(Element.of((String)this.name(), (Object)this.columnsToArray()));
        }
        Optional optionalConverter = this.field().converter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((FieldParameterMetadata)this.field());
            return Collections.singletonList(Element.of((String)this.name(), (Object)attributeConverter.convertToDatabaseColumn(this.value())));
        }
        return Collections.singletonList(Element.of((String)this.name(), (Object)this.value()));
    }

    private List<List<Element>> columns(EntityConverter converter) {
        ArrayList<List<Element>> elements = new ArrayList<List<Element>>();
        for (Object element : (Iterable)this.value()) {
            elements.add(converter.toCommunication(element).elements());
        }
        return elements;
    }

    private Object columnsToArray() {
        if (this.value() instanceof Object[]) {
            ArrayList values = new ArrayList();
            Collections.addAll(values, (Object[])this.value());
            return values;
        }
        return this.value();
    }

    private List<List<Element>> columnsToArray(EntityConverter converter) {
        ArrayList<List<Element>> elements = new ArrayList<List<Element>>();
        for (Object element : (Object[])this.value()) {
            elements.add(converter.toCommunication(element).elements());
        }
        return elements;
    }

    private boolean isEmbeddableCollection() {
        return MappingType.COLLECTION.equals((Object)this.type()) && this.isEmbeddableElement();
    }

    private boolean isEmbeddableArray() {
        return MappingType.ARRAY.equals((Object)this.type()) && this.isArrayEmbeddableElement();
    }

    private MappingType type() {
        return this.field().mappingType();
    }

    private String name() {
        return this.field().name();
    }

    private boolean isEmbeddableElement() {
        return ((CollectionFieldMetadata)this.field()).isEmbeddable();
    }

    private boolean isArrayEmbeddableElement() {
        return ((ArrayFieldMetadata)this.field()).isEmbeddable();
    }

    public String toString() {
        return "ColumnFieldValue{fieldValue=" + this.fieldValue + "}";
    }

    static AttributeFieldValue of(Object value, FieldMetadata field) {
        return new DefaultAttributeFieldValue((FieldValue)new DefaultFieldValue(value, field));
    }
}

