/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.metadata.ArrayParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.CollectionParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.ConstructorBuilder;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.MapParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ParameterConverter {
    DEFAULT{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            metaData.converter().ifPresentOrElse(c -> {
                Object value = converter.converters().get((FieldParameterMetadata)metaData).convertToEntityAttribute(element.get());
                builder.add(value);
            }, () -> builder.add(element.get(metaData.type())));
        }
    }
    ,
    ENTITY{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            Object value = element.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Element> elements = new ArrayList<Element>();
                for (Map.Entry entry : map.entrySet()) {
                    elements.add(Element.of((String)entry.getKey().toString(), entry.getValue()));
                }
                Object entity = converter.toEntity(metaData.type(), elements);
                builder.add(entity);
            } else {
                List columns = (List)element.get((TypeSupplier)new TypeReference<List<Element>>(){});
                Object entity = converter.toEntity(metaData.type(), columns);
                builder.add(entity);
            }
        }
    }
    ,
    COLLECTION{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            CollectionParameterMetaData collectionParameterMetaData = (CollectionParameterMetaData)metaData;
            Collection elements = collectionParameterMetaData.collectionInstance();
            List embeddable = (List)element.get();
            for (List elementsList : embeddable) {
                Object item = converter.toEntity(collectionParameterMetaData.elementType(), elementsList);
                elements.add(item);
            }
            builder.add((Object)elements);
        }
    }
    ,
    MAP{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            MapParameterMetaData mapParameterMetaData = (MapParameterMetaData)metaData;
            Object value = mapParameterMetaData.value(element.value());
            builder.add(value);
        }
    }
    ,
    ARRAY{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            ArrayParameterMetaData arrayParameterMetaData = (ArrayParameterMetaData)metaData;
            List embeddable = (List)element.get();
            Object elements = Array.newInstance(arrayParameterMetaData.elementType(), embeddable.size());
            int index = 0;
            for (List elementsList : embeddable) {
                Object item = converter.toEntity(arrayParameterMetaData.elementType(), elementsList);
                Array.set(elements, index++, item);
            }
            builder.add(elements);
        }
    };


    abstract void convert(EntityConverter var1, Element var2, ParameterMetaData var3, ConstructorBuilder var4);

    static ParameterConverter of(ParameterMetaData parameter, EntitiesMetadata entities) {
        return switch (parameter.mappingType()) {
            case MappingType.COLLECTION -> ParameterConverter.collectionConverter(parameter, entities);
            case MappingType.ARRAY -> ParameterConverter.arrayConverter(parameter, entities);
            case MappingType.MAP -> MAP;
            case MappingType.ENTITY, MappingType.EMBEDDED_GROUP, MappingType.EMBEDDED -> ENTITY;
            default -> DEFAULT;
        };
    }

    private static ParameterConverter collectionConverter(ParameterMetaData parameter, EntitiesMetadata entities) {
        CollectionParameterMetaData genericParameter = (CollectionParameterMetaData)parameter;
        Class type = genericParameter.elementType();
        if (entities.findByClassName(type.getName()).isPresent()) {
            return COLLECTION;
        }
        return DEFAULT;
    }

    private static ParameterConverter arrayConverter(ParameterMetaData parameter, EntitiesMetadata entities) {
        ArrayParameterMetaData genericParameter = (ArrayParameterMetaData)parameter;
        Class type = genericParameter.elementType();
        if (entities.findByClassName(type.getName()).isPresent()) {
            return ARRAY;
        }
        return DEFAULT;
    }
}

