/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.data.page.CursoredPage;
import jakarta.data.page.Page;
import jakarta.data.repository.Query;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.QueryType;
import org.eclipse.jnosql.mapping.PreparedStatement;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.query.AbstractRepository;
import org.eclipse.jnosql.mapping.core.query.AnnotationOperation;
import org.eclipse.jnosql.mapping.core.query.RepositoryType;
import org.eclipse.jnosql.mapping.core.repository.RepositoryReflectionUtils;
import org.eclipse.jnosql.mapping.core.repository.ThrowingSupplier;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.query.CustomRepositoryHandlerBuilder;
import org.eclipse.jnosql.mapping.semistructured.query.SemiStructuredRepositoryProxy;

public class CustomRepositoryHandler
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(CustomRepositoryHandler.class.getName());
    private static final Predicate<Class<?>> IS_ITERABLE = Iterable.class::isAssignableFrom;
    private static final Predicate<Class<?>> IS_STREAM = Stream.class::isAssignableFrom;
    private static final Predicate<Class<?>> IS_OPTIONAL = Optional.class::isAssignableFrom;
    private static final Predicate<Class<?>> IS_PAGE = Page.class::isAssignableFrom;
    private static final Predicate<Class<?>> IS_CURSOR_PAGE = CursoredPage.class::isAssignableFrom;
    private static final Predicate<Class<?>> IS_GENERIC_SUPPORTED_TYPE = IS_ITERABLE.or(IS_STREAM).or(IS_OPTIONAL).or(IS_PAGE).or(IS_CURSOR_PAGE);
    private final EntitiesMetadata entitiesMetadata;
    private final SemiStructuredTemplate template;
    private final Class<?> customRepositoryType;
    private final Converters converters;
    private final SemiStructuredRepositoryProxy<?, ?> defaultRepository;

    CustomRepositoryHandler(EntitiesMetadata entitiesMetadata, SemiStructuredTemplate template, Class<?> customRepositoryType, Converters converters) {
        this.entitiesMetadata = entitiesMetadata;
        this.template = template;
        this.customRepositoryType = customRepositoryType;
        this.converters = converters;
        this.defaultRepository = this.findDefaultRepository();
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] params) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method, this.customRepositoryType);
        LOGGER.fine("Executing the method " + method + " with the parameters " + Arrays.toString(params) + " and the type " + type);
        switch (type) {
            case SAVE: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> AnnotationOperation.SAVE.invoke(new AnnotationOperation.Operation(method, params, this.repository(params, method)))));
            }
            case INSERT: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> AnnotationOperation.INSERT.invoke(new AnnotationOperation.Operation(method, params, this.repository(params, method)))));
            }
            case DELETE: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> AnnotationOperation.DELETE.invoke(new AnnotationOperation.Operation(method, params, this.repository(params, method)))));
            }
            case UPDATE: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> AnnotationOperation.UPDATE.invoke(new AnnotationOperation.Operation(method, params, this.repository(params, method)))));
            }
            case DEFAULT_METHOD: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> InvocationHandler.invokeDefault(instance, method, params)));
            }
            case OBJECT_METHOD: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> method.invoke((Object)this, params)))));
            }
            case PARAMETER_BASED: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.repository(method).executeParameterBased(instance, method, params)));
            }
            case CURSOR_PAGINATION: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.repository(method).executeCursorPagination(instance, method, params)));
            }
            case FIND_ALL: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.repository(method).executeFindAll(instance, method, params)));
            }
            case FIND_BY: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.repository(method).executeFindByQuery(instance, method, params)));
            }
            case CUSTOM_REPOSITORY: {
                Object customRepository = CDI.current().select(method.getDeclaringClass(), new Annotation[0]).get();
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> method.invoke(customRepository, params)));
            }
            case QUERY: {
                RepositoryMetadata repositoryMetadata = this.repositoryMetadata(method);
                if (repositoryMetadata.metadata().isEmpty()) {
                    Query query = method.getAnnotation(Query.class);
                    QueryType queryType = QueryType.parse((String)query.value());
                    Class<?> returnType = method.getReturnType();
                    LOGGER.fine("Executing the query " + query.value() + " with the type " + queryType + " and the return type " + returnType);
                    queryType.checkValidReturn(returnType, query.value());
                    Map parameters = RepositoryReflectionUtils.INSTANCE.getParams(method, params);
                    LOGGER.fine("Parameters: " + parameters);
                    PreparedStatement prepare = this.template.prepare(query.value());
                    parameters.forEach((arg_0, arg_1) -> ((PreparedStatement)prepare).bind(arg_0, arg_1));
                    if (prepare.isCount()) {
                        return prepare.count();
                    }
                    Stream entities = prepare.result();
                    if (CustomRepositoryHandler.isLong(method)) {
                        return entities.count();
                    }
                    return Void.class;
                }
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.repository(method).executeQuery(instance, method, params)));
            }
            case COUNT_BY: 
            case COUNT_ALL: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.defaultRepository().executeCountByQuery(instance, method, params)));
            }
            case EXISTS_BY: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.defaultRepository().executeExistByQuery(instance, method, params)));
            }
            case DELETE_BY: {
                return this.unwrapInvocationTargetException((ThrowingSupplier<Object>)((ThrowingSupplier)() -> this.defaultRepository().executeDeleteByAll(instance, method, params)));
            }
        }
        throw new UnsupportedOperationException("The custom repository does not support the method " + method);
    }

    protected Object unwrapInvocationTargetException(ThrowingSupplier<Object> supplier) throws Throwable {
        try {
            return supplier.get();
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }

    public static CustomRepositoryHandlerBuilder builder() {
        return new CustomRepositoryHandlerBuilder();
    }

    private SemiStructuredRepositoryProxy<?, ?> findDefaultRepository() {
        Method[] methods;
        LOGGER.fine("Looking for the default repository from the custom repository methods: " + this.customRepositoryType);
        for (Method method : methods = this.customRepositoryType.getMethods()) {
            RepositoryType type = RepositoryType.of((Method)method, this.customRepositoryType);
            switch (type) {
                case PARAMETER_BASED: 
                case CURSOR_PAGINATION: 
                case FIND_ALL: 
                case FIND_BY: {
                    LOGGER.fine("The default repository found: " + method);
                    return this.repository(method);
                }
                case SAVE: 
                case INSERT: 
                case DELETE: 
                case UPDATE: {
                    LOGGER.fine("The default repository found: " + method);
                    return this.repository(method, method.getParameters());
                }
            }
        }
        return null;
    }

    private SemiStructuredRepositoryProxy<?, ?> defaultRepository() {
        if (this.defaultRepository == null) {
            throw new UnsupportedOperationException("The custom repository does not contains methods to be used as default: " + this.customRepositoryType);
        }
        return this.defaultRepository;
    }

    private SemiStructuredRepositoryProxy<?, ?> repository(Method method) {
        RepositoryMetadata result = this.repositoryMetadata(method);
        Class<?> entityType = result.typeClass();
        return result.metadata().map(entityMetadata -> new SemiStructuredRepositoryProxy(this.template, (EntityMetadata)entityMetadata, entityType, this.converters)).orElseThrow(() -> new UnsupportedOperationException("The repository does not support the method " + method));
    }

    private RepositoryMetadata repositoryMetadata(Method method) {
        Class typeClass = method.getReturnType();
        if (typeClass.isArray()) {
            typeClass = typeClass.getComponentType();
        } else if (Iterable.class.isAssignableFrom(typeClass) || Stream.class.isAssignableFrom(typeClass) || Optional.class.isAssignableFrom(typeClass)) {
            typeClass = (Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0];
        }
        Optional metadata = this.entitiesMetadata.findByClassName(typeClass.getName());
        return new RepositoryMetadata(typeClass, metadata);
    }

    private AbstractRepository<?, ?> repository(Object[] params, Method method) {
        Optional entity;
        Class<?> typeClass = params[0].getClass();
        if (typeClass.isArray()) {
            typeClass = typeClass.getComponentType();
        } else if (IS_GENERIC_SUPPORTED_TYPE.test(typeClass)) {
            entity = ((Iterable)params[0]).iterator().next();
            typeClass = entity.getClass();
        }
        entity = this.entitiesMetadata.findByClassName(typeClass.getName());
        return entity.map(entityMetadata -> new SemiStructuredRepositoryProxy.SemiStructuredRepository(this.template, (EntityMetadata)entityMetadata)).orElseThrow(() -> new UnsupportedOperationException("The repository does not support the method: " + method));
    }

    private SemiStructuredRepositoryProxy<?, ?> repository(Method method, Parameter[] params) {
        if (params.length == 0) {
            throw new IllegalArgumentException("Method must have at least one parameter");
        }
        Class<?> typeClass = this.getTypeClassFromParameter(params[0]);
        Optional entity = this.entitiesMetadata.findByClassName(typeClass.getName());
        return entity.map(entityMetadata -> new SemiStructuredRepositoryProxy(this.template, (EntityMetadata)entityMetadata, typeClass, this.converters)).orElseThrow(() -> new UnsupportedOperationException("The repository does not support the method: " + method));
    }

    private Class<?> getTypeClassFromParameter(Parameter parameter) {
        Class<?> typeClass = parameter.getType();
        if (typeClass.isArray()) {
            return typeClass.getComponentType();
        }
        if (IS_GENERIC_SUPPORTED_TYPE.test(typeClass)) {
            return this.getGenericTypeFromParameter(parameter);
        }
        return typeClass;
    }

    private Class<?> getGenericTypeFromParameter(Parameter parameter) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type parameterType = parameter.getParameterizedType();
        if (parameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)parameterType).getActualTypeArguments()).length > 0 && actualTypeArguments[0] instanceof Class) {
            return (Class)actualTypeArguments[0];
        }
        throw new IllegalArgumentException("Cannot determine generic type from parameter");
    }

    private static boolean isLong(Method method) {
        return method.getReturnType().equals(Long.TYPE) || method.getReturnType().equals(Long.class);
    }

    private record RepositoryMetadata(Class<?> typeClass, Optional<EntityMetadata> metadata) {
    }
}

