/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.semistructured.MapperObserver;

enum SelectFieldMapper {
    INSTANCE;


    <T> Function<T, T> map(MapperObserver observer, EntitiesMetadata entitiesMetadata) {
        if (observer.fields().isEmpty()) {
            return Function.identity();
        }
        List<String> fields = observer.fields();
        EntityMetadata metadata = entitiesMetadata.findByName(observer.entity());
        if (fields.size() == 1) {
            String field = fields.get(0);
            return entity -> this.field(entity, metadata, field);
        }
        return entity -> this.fields(entity, fields, metadata);
    }

    private <T> T fields(T e, List<String> fields, EntityMetadata metadata) {
        ArrayList<T> values = new ArrayList<T>();
        for (String field : fields) {
            values.add(this.field(e, metadata, field));
        }
        return (T)values.toArray();
    }

    private <T> T field(T entity, EntityMetadata metadata, String field) {
        FieldMetadata fieldMetadata = (FieldMetadata)metadata.fieldMapping(field).orElseThrow();
        Object value = fieldMetadata.read(entity);
        return (T)value;
    }
}

