/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.mapping.metadata.ClassInformationNotFoundException;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

final class MapperObserver
implements CommunicationObserverParser {
    private final EntitiesMetadata mappings;
    private final List<String> fields = new ArrayList<String>();
    private String entity;

    MapperObserver(EntitiesMetadata mappings) {
        this.mappings = mappings;
    }

    public String fireEntity(String entity) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(EntityMetadata::name).orElse(entity);
    }

    public String fireSelectField(String entity, String field) {
        this.fields.add(field);
        return this.mapField(entity, field);
    }

    public String fireSortProperty(String entity, String field) {
        return this.mapField(entity, field);
    }

    public String fireConditionField(String entity, String field) {
        return this.mapField(entity, field);
    }

    List<String> fields() {
        return this.fields;
    }

    String entity() {
        return this.entity;
    }

    private String mapField(String entity, String field) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(c -> c.columnField(field)).orElse(field);
    }

    private Optional<EntityMetadata> getEntityMetadata(String entity) {
        try {
            this.entity = entity;
            return Optional.of(this.mappings.findByName(entity));
        }
        catch (ClassInformationNotFoundException e) {
            return this.mappings.findBySimpleName(entity).or(() -> this.mappings.findByClassName(entity));
        }
    }
}

