/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.metadata.ArrayParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.CollectionParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.ConstructorBuilder;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.MapParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ParameterConverter {
    DEFAULT{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            metaData.converter().ifPresentOrElse(c -> {
                Object value = converter.converters().get((FieldParameterMetadata)metaData).convertToEntityAttribute(element.get());
                builder.add(value);
            }, () -> builder.add(element.get(metaData.type())));
        }
    }
    ,
    ENTITY{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            Object value = element.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Element> elements = new ArrayList<Element>();
                for (Map.Entry entry : map.entrySet()) {
                    elements.add(Element.of((String)entry.getKey().toString(), entry.getValue()));
                }
                Object entity = converter.toEntity(metaData.type(), elements);
                builder.add(entity);
            } else {
                List columns = (List)element.get((TypeSupplier)new TypeReference<List<Element>>(){});
                Object entity = converter.toEntity(metaData.type(), columns);
                builder.add(entity);
            }
        }
    }
    ,
    COLLECTION{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            CollectionParameterMetaData collectionParameterMetaData = (CollectionParameterMetaData)metaData;
            Collection elements = collectionParameterMetaData.collectionInstance();
            List embeddable = (List)element.get();
            for (List elementsList : embeddable) {
                Object item = converter.toEntity(collectionParameterMetaData.elementType(), elementsList);
                elements.add(item);
            }
            builder.add((Object)elements);
        }
    }
    ,
    MAP{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            MapParameterMetaData mapParameterMetaData = (MapParameterMetaData)metaData;
            Map valueMap = (Map)mapParameterMetaData.value(element.value());
            if (mapParameterMetaData.isEmbeddable()) {
                4.executeEmbeddableMap(converter, builder, mapParameterMetaData, valueMap);
            } else {
                builder.add((Object)valueMap);
            }
        }

        private static void executeEmbeddableMap(EntityConverter converter, ConstructorBuilder builder, MapParameterMetaData mapParameterMetaData, Map<?, ?> valueMap) {
            Class type = mapParameterMetaData.valueType();
            HashMap<String, Object> mapEntity = new HashMap<String, Object>();
            for (Object key : valueMap.keySet()) {
                Object document = valueMap.get(key);
                if (document instanceof Map) {
                    Map map = (Map)document;
                    Object entity = 4.getEntity(converter, map, type);
                    mapEntity.put(key.toString(), entity);
                    continue;
                }
                throw new IllegalStateException("Invalid map value type: expected a basic attribute, or a type annotated with @Entity or @Embeddable from jakarta.nosql, but found: " + mapParameterMetaData.valueType());
            }
            builder.add(mapEntity);
        }

        private static Object getEntity(EntityConverter converter, Map map, Class<?> type) {
            ArrayList<Element> embeddedColumns = new ArrayList<Element>();
            for (Map.Entry entry : map.entrySet()) {
                embeddedColumns.add(Element.of((String)entry.getKey().toString(), entry.getValue()));
            }
            return converter.toEntity(type, embeddedColumns);
        }
    }
    ,
    ARRAY{

        @Override
        void convert(EntityConverter converter, Element element, ParameterMetaData metaData, ConstructorBuilder builder) {
            ArrayParameterMetaData arrayParameterMetaData = (ArrayParameterMetaData)metaData;
            List embeddable = (List)element.get();
            Object elements = Array.newInstance(arrayParameterMetaData.elementType(), embeddable.size());
            int index = 0;
            for (List elementsList : embeddable) {
                Object item = converter.toEntity(arrayParameterMetaData.elementType(), elementsList);
                Array.set(elements, index++, item);
            }
            builder.add(elements);
        }
    };


    abstract void convert(EntityConverter var1, Element var2, ParameterMetaData var3, ConstructorBuilder var4);

    static ParameterConverter of(ParameterMetaData parameter, EntitiesMetadata entities) {
        return switch (parameter.mappingType()) {
            case MappingType.COLLECTION -> ParameterConverter.collectionConverter(parameter);
            case MappingType.ARRAY -> ParameterConverter.arrayConverter(parameter);
            case MappingType.MAP -> MAP;
            case MappingType.ENTITY, MappingType.EMBEDDED_GROUP, MappingType.EMBEDDED -> ENTITY;
            default -> DEFAULT;
        };
    }

    private static ParameterConverter collectionConverter(ParameterMetaData parameter) {
        CollectionParameterMetaData genericParameter = (CollectionParameterMetaData)parameter;
        if (genericParameter.isEmbeddable()) {
            return COLLECTION;
        }
        return DEFAULT;
    }

    private static ParameterConverter arrayConverter(ParameterMetaData parameter) {
        ArrayParameterMetaData arrayParameterMetaData = (ArrayParameterMetaData)parameter;
        if (arrayParameterMetaData.isEmbeddable()) {
            return ARRAY;
        }
        return DEFAULT;
    }
}

