/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.data.Limit;
import jakarta.data.page.PageRequest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.mapping.core.NoSQLPage;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.core.repository.SpecialParameters;
import org.eclipse.jnosql.mapping.semistructured.MappingQuery;

public class DynamicQuery
implements Supplier<SelectQuery> {
    private final SpecialParameters special;
    private final SelectQuery query;

    DynamicQuery(SpecialParameters special, SelectQuery query) {
        this.special = special;
        this.query = query;
    }

    @Override
    public SelectQuery get() {
        if (this.special.isEmpty()) {
            return this.query;
        }
        Optional limit = this.special.limit();
        if (this.special.hasOnlySort()) {
            ArrayList sorts = new ArrayList();
            sorts.addAll(this.query.sorts());
            sorts.addAll(this.special.sorts());
            long skip = limit.map(l -> l.startAt() - 1L).orElse(this.query.skip());
            long max = limit.map(Limit::maxResults).orElse((int)this.query.limit()).intValue();
            return new MappingQuery(sorts, max, skip, this.query.condition().orElse(null), this.query.name());
        }
        if (limit.isPresent()) {
            long skip = limit.map(l -> l.startAt() - 1L).orElse(this.query.skip());
            long max = limit.map(Limit::maxResults).orElse((int)this.query.limit()).intValue();
            ArrayList sorts = this.query.sorts();
            if (!this.special.sorts().isEmpty()) {
                sorts = new ArrayList(this.query.sorts());
                sorts.addAll(this.special.sorts());
            }
            return new MappingQuery(sorts, max, skip, this.query.condition().orElse(null), this.query.name());
        }
        return this.special.pageRequest().map(p -> {
            long size = p.size();
            long skip = NoSQLPage.skip((PageRequest)p);
            ArrayList sorts = this.query.sorts();
            if (!this.special.sorts().isEmpty()) {
                sorts = new ArrayList(this.query.sorts());
                sorts.addAll(this.special.sorts());
            }
            return new MappingQuery(sorts, size, skip, this.query.condition().orElse(null), this.query.name());
        }).orElse(this.query);
    }

    public static DynamicQuery of(Object[] args, SelectQuery query) {
        Objects.requireNonNull(args, "args is required");
        Objects.requireNonNull(query, "query is required");
        return new DynamicQuery(DynamicReturn.findSpecialParameters((Object[])args, Function.identity()), query);
    }
}

