/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.mongodb;

import jakarta.nosql.Settings;
import jakarta.nosql.mapping.MappingException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import org.eclipse.jnosql.communication.mongodb.document.MongoDBDocumentConfiguration;
import org.eclipse.jnosql.communication.mongodb.document.MongoDBDocumentManager;
import org.eclipse.jnosql.communication.mongodb.document.MongoDBDocumentManagerFactory;
import org.eclipse.jnosql.mapping.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.config.MicroProfileSettings;

@ApplicationScoped
class DocumentManagerSupplier
implements Supplier<MongoDBDocumentManager> {
    private static final Logger LOGGER = Logger.getLogger(DocumentManagerSupplier.class.getName());

    DocumentManagerSupplier() {
    }

    @Override
    @Produces
    @Typed(value={MongoDBDocumentManager.class})
    public MongoDBDocumentManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        MongoDBDocumentConfiguration configuration = new MongoDBDocumentConfiguration();
        MongoDBDocumentManagerFactory factory = configuration.apply((Settings)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.DOCUMENT_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.DOCUMENT_DATABASE));
        MongoDBDocumentManager manager = factory.apply(db);
        LOGGER.log(Level.FINEST, "Starting  a MongoDBDocumentManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes MongoDBDocumentManager manager) {
        LOGGER.log(Level.FINEST, "Closing MongoDBDocumentManager resource, database name: " + manager.getName());
        manager.close();
    }
}

