/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.mongodb.criteria;

import jakarta.nosql.Sort;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentQuery;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.BinaryPredicate;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.CompositionPredicate;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.DisjunctionPredicate;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.Expression;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.ExpressionQuery;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.NegationPredicate;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.Path;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.Predicate;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.RangePredicate;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.Root;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.SelectQuery;
import org.eclipse.jnosql.mapping.util.StringUtils;

public class CriteriaQueryUtils {
    private CriteriaQueryUtils() {
    }

    public static String join(String ... values) {
        return String.join((CharSequence)".", values);
    }

    public static String unfold(Path path) {
        Path tmp = path;
        ArrayDeque<String> attributes = new ArrayDeque<String>();
        while (Objects.nonNull(tmp) && !(tmp instanceof Root)) {
            attributes.add(tmp.getAttribute().getName());
            tmp = tmp.getParent();
        }
        return CriteriaQueryUtils.join((String[])attributes.stream().filter(value -> StringUtils.isNotBlank((CharSequence)value.trim())).toArray(String[]::new));
    }

    public static String unfold(Expression expression) {
        return CriteriaQueryUtils.join((String[])Arrays.asList(CriteriaQueryUtils.unfold(expression.getPath()), expression.getAttribute().getName()).stream().filter(value -> !Objects.equals(0, value.trim().length())).toArray(String[]::new));
    }

    public static DocumentCondition computeCondition(Predicate predicate) {
        DocumentCondition result = null;
        if (predicate instanceof CompositionPredicate) {
            Collection restrictions = ((CompositionPredicate)CompositionPredicate.class.cast(predicate)).getPredicates();
            Function<DocumentCondition[], DocumentCondition> function = predicate instanceof DisjunctionPredicate ? DocumentCondition::or : DocumentCondition::and;
            result = function.apply((DocumentCondition[])restrictions.stream().map(CriteriaQueryUtils::computeCondition).toArray(DocumentCondition[]::new));
        } else if (predicate instanceof NegationPredicate) {
            result = CriteriaQueryUtils.computeCondition(((NegationPredicate)NegationPredicate.class.cast(predicate)).getPredicate()).negate();
        } else if (predicate instanceof BinaryPredicate) {
            BiFunction<String, Object, DocumentCondition> bifunction;
            BinaryPredicate cast = (BinaryPredicate)BinaryPredicate.class.cast(predicate);
            String lhs = CriteriaQueryUtils.unfold(cast.getLeft());
            Object rhs = cast.getRight();
            if (rhs instanceof Expression) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            switch (cast.getOperator()) {
                case EQUAL: {
                    bifunction = DocumentCondition::eq;
                    break;
                }
                case GREATER_THAN: {
                    bifunction = DocumentCondition::gt;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    bifunction = DocumentCondition::gte;
                    break;
                }
                case LESS_THAN: {
                    bifunction = DocumentCondition::lt;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    bifunction = DocumentCondition::lte;
                    break;
                }
                case IN: {
                    bifunction = DocumentCondition::in;
                    break;
                }
                case LIKE: {
                    bifunction = DocumentCondition::like;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
            result = bifunction.apply(lhs, rhs);
        } else if (predicate instanceof RangePredicate) {
            BiFunction<String, Object, DocumentCondition> bifunction;
            RangePredicate cast = (RangePredicate)RangePredicate.class.cast(predicate);
            String lhs = CriteriaQueryUtils.unfold(cast.getLeft());
            Object from = cast.getFrom();
            Object to = cast.getTo();
            if (from instanceof Expression || to instanceof Expression) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            switch (cast.getOperator()) {
                case EXCLUSIVE_BETWEEN: 
                case INCLUSIVE_BETWEEN: {
                    bifunction = DocumentCondition::between;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
            result = bifunction.apply(lhs, Arrays.asList(from, to));
        }
        if (Objects.isNull(result)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return result;
    }

    public static <X> DocumentQuery convert(SelectQuery<X, ?, ?, ?> selectQuery) {
        DocumentQuery.DocumentQueryBuilder builder;
        Objects.requireNonNull(selectQuery, "query is required");
        if (selectQuery instanceof ExpressionQuery) {
            ExpressionQuery expressionQuery = (ExpressionQuery)ExpressionQuery.class.cast(selectQuery);
            builder = DocumentQuery.builder((String[])((String[])expressionQuery.getExpressions().stream().map(CriteriaQueryUtils::unfold).toArray(String[]::new)));
        } else {
            builder = DocumentQuery.builder();
        }
        DocumentQuery.DocumentQueryBuilder where = builder.from(selectQuery.getType().getSimpleName()).where(DocumentCondition.and((DocumentCondition[])((DocumentCondition[])((Collection)Optional.ofNullable(selectQuery.getRestrictions()).orElse(Collections.emptyList())).stream().map(CriteriaQueryUtils::computeCondition).toArray(DocumentCondition[]::new)))).sort((Sort[])Optional.ofNullable(selectQuery.getOrderBy()).orElse(Collections.emptyList()).stream().map(orderBy -> {
            String unfold = CriteriaQueryUtils.unfold(orderBy.getExpression());
            return orderBy.isAscending() ? Sort.asc((String)unfold) : Sort.desc((String)unfold);
        }).toArray(Sort[]::new));
        DocumentQuery.DocumentQueryBuilder limit = Optional.ofNullable(selectQuery.getMaxResults()).map(arg_0 -> ((DocumentQuery.DocumentQueryBuilder)where).limit(arg_0)).orElse(where);
        DocumentQuery.DocumentQueryBuilder skip = Optional.ofNullable(selectQuery.getFirstResult()).map(arg_0 -> ((DocumentQuery.DocumentQueryBuilder)limit).skip(arg_0)).orElse(limit);
        return skip.build();
    }
}

