/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.J2EEComponentArchiveSaveAdapter;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebComponentArchiveSaveAdapter
extends J2EEComponentArchiveSaveAdapter {
    protected Map nonStandardSourceFiles;

    public WebComponentArchiveSaveAdapter(IVirtualComponent vComponent) {
        super(vComponent);
    }

    protected boolean shouldAddImportedClassesToClasspath() {
        return false;
    }

    protected String getImportedClassesURI(IArchive aFile) {
        return aFile.getPath().lastSegment().toString();
    }

    protected IPath getImportedClassesRuntimePath() {
        return new Path("/WEB-INF/classes/");
    }

    protected IPath getOutputPathForFile(IArchive aFile) {
        if (this.nonStandardSourceFiles != null && this.nonStandardSourceFiles.containsKey(aFile)) {
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualFile vFile = rootFolder.getFile((String)this.nonStandardSourceFiles.get(aFile));
            IFile iFile = vFile.getUnderlyingFile();
            return iFile.getProjectRelativePath();
        }
        return super.getOutputPathForFile((IArchiveResource)aFile);
    }

    protected boolean isClassWithoutSource(IArchive aFile) {
        int _index;
        String javaUri = ArchiveUtil.classUriToJavaUri((String)aFile.getPath().toString());
        if (javaUri == null) {
            return false;
        }
        if (this.archive.containsArchiveResource(aFile.getPath())) {
            return false;
        }
        String jspUri = javaUri.substring(0, javaUri.indexOf(".java"));
        int lastSlash = jspUri.lastIndexOf(47);
        int n = _index = lastSlash == -1 ? "WEB-INF/classes/".length() : lastSlash + 1;
        if (jspUri.charAt(_index) == '_') {
            jspUri = String.valueOf(jspUri.substring("WEB-INF/classes/".length(), _index)) + jspUri.substring(_index + 1) + ".jsp";
            if (this.archive.containsArchiveResource(aFile.getPath())) {
                return false;
            }
        }
        return false;
    }
}

