/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.SourceViewerCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.itemcreation.command.SingletonContainerCreationCommand;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PaletteDropInsertCommand
extends SourceViewerCommand {
    private final Logger _log = PDPlugin.getLogger(PaletteDropInsertCommand.class);
    private TagToolPaletteEntry _tagItem;
    private int _location;
    private List _nodesToFormat = new ArrayList();
    private Element _element;

    public PaletteDropInsertCommand(String label, StructuredTextEditor editor, TagToolPaletteEntry tagItem, int location) {
        super(label, editor);
        this._tagItem = tagItem;
        this._location = location;
    }

    public void doExecute() {
        IDOMModel model = this.getModel();
        try {
            Node node = this.getSourceEditingTextTools().getNode(this._location);
            IDOMPosition position = null;
            position = node != null ? SourceViewerDragDropHelper.getInstance().findPosition(this._location, node) : new DOMPosition((Node)this.getModel().getDocument(), 0);
            Assert.isTrue((position != null ? 1 : 0) != 0);
            if (!this._tagItem.getURI().equalsIgnoreCase("html") && !this._tagItem.getURI().equalsIgnoreCase("jsp")) {
                SingletonContainerCreationCommand command = new SingletonContainerCreationCommand(position, IJSFConstants.TAG_IDENTIFIER_VIEW, null);
                command.execute();
                Iterator<IDOMPosition> it = command.getResult().iterator();
                if (it.hasNext()) {
                    position = command.getResult().iterator().next();
                } else {
                    throw new IllegalStateException("Expected result of command");
                }
            }
            this._element = CommandUtil.excuteInsertion(this._tagItem, model, position, null);
            if (this._element != null) {
                this._nodesToFormat.add(this._element);
                SourceViewerDragDropHelper.getInstance().changeCaret(this._editor, true);
                this.formatNodes();
            }
        }
        catch (Exception e) {
            this._log.error("Bad text insertion location", (Throwable)e);
        }
    }

    public void setSelection() {
        if (this._element != null) {
            int offset = EditModelQuery.getNodeStartIndex(this._element);
            int length = EditModelQuery.getNodeEndIndex(this._element) - offset;
            this._editor.getTextViewer().setSelectedRange(offset, length);
        }
    }

    private void formatNodes() {
        int i = 0;
        int n = this._nodesToFormat.size();
        while (i < n) {
            this.formatNode((Node)this._nodesToFormat.get(i));
            ++i;
        }
    }
}

