/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jst.pagedesigner.commands.range.DeleteEdit;
import org.eclipse.jst.pagedesigner.commands.range.IInputSourceProvider;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class InsertEdit
extends DeleteEdit {
    private IInputSourceProvider _data;

    public boolean operate() {
        DOMRange range = this.getRange();
        if (!EditModelQuery.isSame(range.getStartPosition(), range.getEndPosition())) {
            this.deleteRange();
            range = new DOMRange(this.getOperationPosition(), this.getOperationPosition());
            this.setRange(range);
        }
        if (this.insertNodes()) {
            return true;
        }
        if (this.insertString()) {
            return true;
        }
        return this.insertChar();
    }

    public InsertEdit(DOMRange range, GraphicalViewer viewer, IInputSourceProvider data) {
        super(range, viewer);
        this._data = data;
    }

    public InsertEdit(IDOMPosition position, GraphicalViewer viewer, IInputSourceProvider data) {
        super(new DOMRange(position, position), viewer);
        this.setOperationPosition(position);
        this._data = data;
    }

    public boolean insertChar() {
        if (this._data.getStringData() == null) {
            return false;
        }
        IDOMPosition position = this.getOperationPosition();
        if (position.isText()) {
            Text text = EditModelQuery.getInstance().getText(position);
            text.insertData(this.getOperationPosition().getOffset(), this._data.getCharacterData().toString());
            this.setOperationPosition(new DOMPosition(text, position.getOffset() + 1));
        } else {
            Node refNode = position.getNextSiblingNode();
            Text text = this._document.createTextNode(this._data.getCharacterData().toString());
            position.getContainerNode().insertBefore(text, refNode);
            this.setOperationPosition(new DOMPosition(text, text.getLength()));
        }
        return true;
    }

    public boolean insertString() {
        String content = this._data.getStringData();
        if (content != null) {
            IDOMPosition position = this.getOperationPosition();
            if (position.isText()) {
                Text text = EditModelQuery.getInstance().getText(position);
                text.insertData(this.getOperationPosition().getOffset(), content);
                this.setOperationPosition(new DOMPosition(text, position.getOffset() + content.length()));
            } else {
                Node refNode = position.getNextSiblingNode();
                Text text = this._document.createTextNode(content);
                position.getContainerNode().insertBefore(text, refNode);
                this.setOperationPosition(new DOMPosition(text, text.getLength()));
            }
            return true;
        }
        return false;
    }

    private boolean insertNodes() {
        Node[] nodes = this._data.getNodes();
        if (nodes == null) {
            return false;
        }
        IDOMPosition position = this.getOperationPosition();
        if (position == null) {
            return false;
        }
        Node refNode = null;
        if (position.isText()) {
            position = DOMPositionHelper.splitText(position);
        }
        refNode = position.getNextSiblingNode();
        Node parent = position.getContainerNode();
        Node node = null;
        int i = 0;
        while (i < nodes.length) {
            node = DOMUtil.cloneNodeDeep(this._document, nodes[i]);
            String prefix = node.getPrefix();
            String name = node.getLocalName();
            if (name != null && "jsp".equals(prefix) && (node.getLocalName().startsWith("directive.") || "declaration".equals(name) || "expression".equals(name) || "scriptlet".equals(name))) {
                ((IDOMElement)node).setJSPTag(true);
            }
            node = parent.insertBefore(node, refNode);
            ++i;
        }
        if (node != null) {
            this.setOperationPosition(new DOMRefPosition(node, true));
        } else if (refNode != null) {
            this.setOperationPosition(new DOMRefPosition(refNode, false));
        } else {
            this.setOperationPosition(new DOMRefPosition(parent.getLastChild(), true));
        }
        return true;
    }
}

