/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.color;

import java.util.StringTokenizer;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.color.CSSColorDefaults;
import org.eclipse.swt.graphics.RGB;

public class CSSColorConverter {
    private static final String PREFIX_RGB = "rgb";
    private static Logger _log = PDPlugin.getLogger(CSSColorConverter.class);
    private static CSSColorConverter _instance = new CSSColorConverter();

    public static CSSColorConverter getInstantce() {
        if (_instance == null) {
            _instance = new CSSColorConverter();
        }
        return _instance;
    }

    protected Object getCSSColor(String CSSText) {
        if (CSSText == null) {
            return null;
        }
        if ((CSSText = CSSText.trim().toLowerCase()).length() == 0) {
            return null;
        }
        if (CSSColorDefaults.SYSTEM_DEFAULT_COLORS.containsKey(CSSText)) {
            Object result = null;
            result = CSSColorDefaults.SYSTEM_DEFAULT_COLORS.get(CSSText);
            return result;
        }
        if (CSSColorDefaults.EXTENDED_COLORS.containsKey(CSSText)) {
            Object result = null;
            result = CSSColorDefaults.EXTENDED_COLORS.get(CSSText);
            return result;
        }
        return this.convertStringToRGB(CSSText);
    }

    private RGB convertStringToRGB(String CSSText) {
        StringBuffer sb = new StringBuffer(CSSText);
        try {
            if (sb.indexOf("#") == 0) {
                if (sb.length() == 4) {
                    sb.insert(1, sb.charAt(1));
                    sb.insert(3, sb.charAt(3));
                    sb.insert(5, sb.charAt(5));
                    int value = Integer.parseInt(sb.substring(1, sb.length()).toString(), 16);
                    return new RGB(value >>> 16 & 0xFF, value >>> 8 & 0xFF, value & 0xFF);
                }
                if (sb.length() == 7) {
                    int value = Integer.parseInt(sb.substring(1, sb.length()), 16);
                    return new RGB(value >>> 16 & 0xFF, value >>> 8 & 0xFF, value & 0xFF);
                }
            } else if (CSSText.startsWith(PREFIX_RGB)) {
                return this.convertRgbToRGB(sb.substring(sb.indexOf("(") + 1, sb.indexOf(")")));
            }
        }
        catch (Exception exception) {
            _log.info("CSSColorConverter.0", CSSText, null);
            return null;
        }
        return null;
    }

    private RGB convertRgbToRGB(String text) {
        StringTokenizer tokenizer;
        block10: {
            text = text.trim();
            tokenizer = new StringTokenizer(text, ",");
            if (tokenizer.countTokens() == 3) break block10;
            return null;
        }
        try {
            String[] rgbText = new String[3];
            int i = 0;
            while (i < 3) {
                rgbText[i] = tokenizer.nextToken();
                ++i;
            }
            int[] intRGB = new int[3];
            int i2 = 0;
            while (i2 < 3) {
                int intValue = -1;
                String textValue = rgbText[i2].trim();
                if (textValue.endsWith("%")) {
                    textValue = textValue.substring(0, textValue.length() - 1);
                    intValue = Integer.parseInt(textValue) * 255 / 100;
                } else {
                    intValue = Integer.parseInt(textValue);
                }
                if (intValue < 0) {
                    intValue = 0;
                } else if (intValue > 255) {
                    intValue = 255;
                }
                intRGB[i2] = intValue;
                ++i2;
            }
            return new RGB(intRGB[0], intRGB[1], intRGB[2]);
        }
        catch (Exception exception) {
            _log.info("CSSColorConverter.1", text, null);
            return null;
        }
    }
}

