/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.adapters.IBodyInfo;
import org.eclipse.jst.pagedesigner.adapters.internal.BodyInfo;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ValidatorSupport {
    public static boolean checkContainer(IDOMPosition position, QName qname) {
        return ValidatorSupport.checkContainer(position, new QName[]{qname});
    }

    public static boolean checkContainer(IDOMPosition position, QName[] qname) {
        Node node = position.getContainerNode();
        while (node != null) {
            if (node instanceof Text) {
                node = node.getParentNode();
                continue;
            }
            if (!(node instanceof Element)) break;
            Element ele = (Element)node;
            String url = CMUtil.getElementNamespaceURI((Element)ele);
            String tag = ele.getLocalName();
            int i = 0;
            while (i < qname.length) {
                if (tag.equalsIgnoreCase(qname[i].getLocalPart())) {
                    if (url == null) {
                        return true;
                    }
                    if (url.equalsIgnoreCase(qname[i].getNamespaceURI())) {
                        return true;
                    }
                }
                ++i;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public static IDOMPosition insertContainer(IDOMPosition position, QName container, IAdaptable customizationData) {
        IDOMModel model;
        TagToolPaletteEntry tagItem;
        Element form;
        TaglibPaletteDrawer category = PaletteItemManager.getCurrentInstance().findCategoryByURI(container.getNamespaceURI());
        if (category != null && (form = CommandUtil.excuteInsertion(tagItem = category.getTagPaletteEntryByTagName(container.getLocalPart()), model = ((IDOMNode)position.getContainerNode()).getModel(), position, customizationData)) != null) {
            DOMPosition pos = new DOMPosition(form, 0);
            return pos;
        }
        return null;
    }

    public static IBodyInfo getBodyInfo() {
        return BodyInfo.getInstance();
    }
}

