/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.operations;

import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IClassLoaderProvider;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.AppendChildElementOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.AppendChildTextFromXPathOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.AppendChildTextOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.ConvertAttributeToTextOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.CopyAllAttributesOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.CopyAttributeOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.CopyChildrenOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.CreateAttributeFromXPathOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.CreateAttributeOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.CreateElementOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.IfNotOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.IfOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.IterateOverElementsOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.MakeParentElementCurrentOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.RemoveAttributeOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal.RenameAttributeOperation;

public class TransformOperationFactory {
    public static final String OP_AppendChildElementOperation = "AppendChildElementOperation";
    public static final String OP_AppendChildTextFromXPathOperation = "AppendChildTextFromXPathOperation";
    public static final String OP_AppendChildTextOperation = "AppendChildTextOperation";
    public static final String OP_ConvertAttributeToTextOperation = "ConvertAttributeToTextOperation";
    public static final String OP_CopyAllAttributesOperation = "CopyAllAttributesOperation";
    public static final String OP_CopyAttributeOperation = "CopyAttributeOperation";
    public static final String OP_CopyChildrenOperation = "CopyChildrenOperation";
    public static final String OP_CreateAttributeFromXPathOperation = "CreateAttributeFromXPathOperation";
    public static final String OP_CreateAttributeOperation = "CreateAttributeOperation";
    public static final String OP_CreateElementOperation = "CreateElementOperation";
    public static final String OP_CustomTransformOperation = "CustomTransformOperation";
    public static final String OP_IfNotOperation = "IfNotOperation";
    public static final String OP_IfOperation = "IfOperation";
    public static final String OP_IterateOverElementsOperation = "IterateOverElementsOperation";
    public static final String OP_MakeParentElementCurrentOperation = "MakeParentElementCurrentOperation";
    public static final String OP_RemoveAttributeOperation = "RemoveAttributeOperation";
    public static final String OP_RenameAttributeOperation = "RenameAttributeOperation";
    private static TransformOperationFactory instance;
    private Logger log = PDPlugin.getLogger(TransformOperationFactory.class);

    private TransformOperationFactory() {
    }

    public static synchronized TransformOperationFactory getInstance() {
        if (instance == null) {
            instance = new TransformOperationFactory();
        }
        return instance;
    }

    public ITransformOperation getTransformOperation(String opID, String[] params) {
        return this.getTransformOperation(opID, params, null);
    }

    public ITransformOperation getTransformOperation(String opID, String[] params, Trait trait) {
        ITransformOperation operation;
        block76: {
            operation = null;
            if (opID.equals(OP_AppendChildElementOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else if (params.length < 2) {
                    String elementName = params[0];
                    operation = new AppendChildElementOperation(elementName);
                } else {
                    String elementName = params[0];
                    boolean makeChildCurrent = Boolean.valueOf(params[1]);
                    operation = new AppendChildElementOperation(elementName, makeChildCurrent);
                }
            } else if (opID.equals(OP_AppendChildTextFromXPathOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String xPathExpression = params[0];
                    operation = new AppendChildTextFromXPathOperation(xPathExpression);
                }
            } else if (opID.equals(OP_AppendChildTextOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String content = params[0];
                    operation = new AppendChildTextOperation(content);
                }
            } else if (opID.equals(OP_ConvertAttributeToTextOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else if (params.length < 2) {
                    String attrName = params[0];
                    operation = new ConvertAttributeToTextOperation(attrName);
                } else {
                    String attrName = params[0];
                    boolean removeAttr = Boolean.valueOf(params[1]);
                    operation = new ConvertAttributeToTextOperation(attrName, removeAttr);
                }
            } else if (opID.equals(OP_CopyAllAttributesOperation)) {
                operation = new CopyAllAttributesOperation();
            } else if (opID.equals(OP_CopyAttributeOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else if (params.length < 3) {
                    String attrName = params[0];
                    operation = new CopyAttributeOperation(attrName);
                } else {
                    String attrName = params[0];
                    boolean create = Boolean.valueOf(params[1]);
                    String newAttrValue = params[2];
                    operation = new CopyAttributeOperation(attrName, create, newAttrValue);
                }
            } else if (opID.equals(OP_CopyChildrenOperation)) {
                operation = new CopyChildrenOperation();
            } else if (opID.equals(OP_CreateAttributeFromXPathOperation)) {
                if (params.length < 2) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String attrName = params[0];
                    String xPathExpression = params[1];
                    operation = new CreateAttributeFromXPathOperation(attrName, xPathExpression);
                }
            } else if (opID.equals(OP_CreateAttributeOperation)) {
                if (params.length < 2) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String attrName = params[0];
                    String attrValue = params[1];
                    operation = new CreateAttributeOperation(attrName, attrValue);
                }
            } else if (opID.equals(OP_CreateElementOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String elementName = params[0];
                    operation = new CreateElementOperation(elementName);
                }
            } else if (opID.equals(OP_CustomTransformOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String className = params[0];
                    if (trait == null) {
                        this.log.error("Warning.TransformOperationFactory.ClassNotFound", className);
                    } else {
                        try {
                            IClassLoaderProvider classLoaderProvider = (IClassLoaderProvider)trait.getSourceModelProvider().getAdapter(IClassLoaderProvider.class);
                            if (classLoaderProvider == null) break block76;
                            Class opClass = classLoaderProvider.loadClass(className);
                            if (opClass != null) {
                                Object opObject = opClass.newInstance();
                                if (opObject instanceof ITransformOperation) {
                                    operation = (ITransformOperation)opObject;
                                } else {
                                    this.log.error("Warning.TransformOperationFactory.NotITransformOperation", className);
                                }
                                break block76;
                            }
                            this.log.error("Warning.TransformOperationFactory.ClassNotFound", className);
                        }
                        catch (IllegalAccessException iae) {
                            this.log.error("Warning.TransformOperationFactory.IllegalAccess", className, (Throwable)iae);
                        }
                        catch (InstantiationException ie) {
                            this.log.error("Warning.TransformOperationFactory.Instantiation", className, (Throwable)ie);
                        }
                    }
                }
            } else if (opID.equals(OP_IfNotOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String xPathExpression = params[0];
                    operation = new IfNotOperation(xPathExpression);
                }
            } else if (opID.equals(OP_IfOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String xPathExpression = params[0];
                    operation = new IfOperation(xPathExpression);
                }
            } else if (opID.equals(OP_IterateOverElementsOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String xPathExpression = params[0];
                    operation = new IterateOverElementsOperation(xPathExpression);
                }
            } else if (opID.equals(OP_MakeParentElementCurrentOperation)) {
                operation = new MakeParentElementCurrentOperation();
            } else if (opID.equals(OP_RemoveAttributeOperation)) {
                if (params.length < 1) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String attrName = params[0];
                    operation = new RemoveAttributeOperation(attrName);
                }
            } else if (opID.equals(OP_RenameAttributeOperation)) {
                if (params.length < 2) {
                    this.log.error("Warning.TransformOperationFactory.TooFewParameters", opID);
                } else {
                    String oldAttrName = params[0];
                    String newAttrName = params[1];
                    operation = new RenameAttributeOperation(oldAttrName, newAttrName);
                }
            } else {
                this.log.error("Warning.TransformOperationFactory.UnknownOperationID", opID);
            }
        }
        return operation;
    }
}

