/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.meta.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocaleFallback {
    private static Map map = new HashMap();

    public static synchronized String[] fallBack(Locale locale) {
        if (map.get(locale) != null) {
            return (String[])map.get(locale);
        }
        List inputLocaleList = LocaleFallback.calculateLocaleNames(locale);
        String[] ins = LocaleFallback.reverseList(inputLocaleList);
        int defsSize = 0;
        String[] defs = null;
        if (!locale.equals(Locale.getDefault())) {
            List defLocaleList = LocaleFallback.calculateLocaleNames(Locale.getDefault());
            defs = LocaleFallback.reverseList(defLocaleList);
            defsSize = defs.length;
        }
        int insSize = ins.length;
        int size = insSize + defsSize;
        String[] options = new String[size + 1];
        int i = 0;
        while (i < size) {
            options[i] = i < insSize ? ins[i] : defs[i - insSize];
            ++i;
        }
        options[size] = "";
        map.put(locale, options);
        return options;
    }

    private static List calculateLocaleNames(Locale locale) {
        ArrayList<String> list = new ArrayList<String>();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int languageLength = language.length();
        int countryLength = country.length();
        int variantLength = variant.length();
        if (languageLength == 0 && countryLength == 0 && variantLength == 0) {
            return list;
        }
        StringBuffer item = new StringBuffer();
        item = item.append('_').append(language);
        list.add(item.toString());
        if (countryLength == 0 && variantLength == 0) {
            return list;
        }
        item.append('_').append(country);
        list.add(item.toString());
        if (variantLength == 0) {
            return list;
        }
        item.append('_').append(variantLength);
        list.add(item.toString());
        return list;
    }

    private static String[] reverseList(List list) {
        int size = list.size();
        String[] vals = new String[size];
        int i = 0;
        while (i < size) {
            vals[i] = (String)list.get(size - 1 - i);
            ++i;
        }
        return vals;
    }
}

