/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ComboDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StyleComboDialogField;
import org.eclipse.jst.pagedesigner.css2.CSSUtil;
import org.eclipse.jst.pagedesigner.meta.IAttributeCellEditorFactory;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.properties.celleditors.CSSDialogCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.LabeledComboBoxCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.LabeledStyleComboCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.LoadbundleSelectionCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.NamedBooleanCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.ResourceBoundle;
import org.eclipse.jst.pagedesigner.properties.celleditors.ResourceDialogCellEditor;
import org.eclipse.jst.pagedesigner.ui.dialogfields.ContextableClasspathResourceButtonDialogField;
import org.eclipse.jst.pagedesigner.ui.dialogfields.ContextableResourceButtonDialogField;
import org.eclipse.jst.pagedesigner.ui.dialogfields.StyleButtonDialogField;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class CellEditorFactory
implements IAttributeCellEditorFactory {
    private static String[] CURRENCYCODES = new String[]{"AED", "AFA", "ALL", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZM", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD", "BND", "BOB", "BRL", "BSD", "BTN", "BWP", "BYR", "BZD", "CAD", "CDF", "CHF", "CLP", "CNY", "COP", "CRC", "CSD", "CUP", "CVE", "CYP", "CZK", "DJF", "DKK", "DOP", "DZD", "EEK", "EGP", "ERN", "ETB", "EUR", "FJD", "FKP", "GBP", "GEL", "GGP", "GHC", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HRK", "HTG", "HUF", "IDR", "ILS", "IMP", "INR", "IQD", "IRR", "ISK", "JEP", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LVL", "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRO", "MTL", "MUR", "MVR", "MWK", "MXN", "MYR", "MZM", "NAD", "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "ROL", "RUB", "RWF", "SAR", "SBD", "SCR", "SDD", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SPL", "SRD", "STD", "SVC", "SYP", "SZL", "THB", "TJS", "TMM", "TND", "TOP", "TRL", "TRY", "TTD", "TVD", "TWD", "TZS", "UAH", "UGX", "USD", "UYU", "UZS", "VEB", "VND", "VUV", "WST", "XAF", "XAG", "XAU", "XCD", "XDR", "XOF", "XPD", "XPF", "XPT", "YER", "ZAR", "ZMK", "ZWD"};

    public CellEditor createCellEditor(Composite parent, IAttributeDescriptor attr, Element element) {
        String type = attr.getValueType();
        if ("ENUMERATED".equalsIgnoreCase(type)) {
            HashMap map = new HashMap(attr.getOptions());
            String defaultValue = attr.getDefaultValue();
            if (defaultValue == null) {
                return LabeledComboBoxCellEditor.newInstance(parent, map, 0);
            }
            return LabeledStyleComboCellEditor.newInstance(parent, map, defaultValue, 0);
        }
        if ("LOCALE".equalsIgnoreCase(type)) {
            HashMap<String, String> map = new HashMap<String, String>();
            Locale[] locales = Locale.getAvailableLocales();
            int i = 0;
            int size = locales.length;
            while (i < size) {
                map.put(locales[i].toString(), locales[i].toString());
                ++i;
            }
            return LabeledComboBoxCellEditor.newInstance(parent, map, 0);
        }
        if ("TIMEZONE".equalsIgnoreCase(type)) {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] ids = TimeZone.getAvailableIDs();
            int i = 0;
            int size = ids.length;
            while (i < size) {
                map.put(ids[i], ids[i]);
                ++i;
            }
            return LabeledComboBoxCellEditor.newInstance(parent, map, 0);
        }
        if ("RELATIVEPATH".equalsIgnoreCase(type) || "WEBPATH".equalsIgnoreCase(type)) {
            IProject project = this.getProject(element);
            if (project != null) {
                ResourceDialogCellEditor cellEditor = new ResourceDialogCellEditor(parent);
                cellEditor.setSuffixs(attr.getParameterByName("suffix").split(";"));
                cellEditor.setSeparator(attr.getParameterByName("separator"));
                cellEditor.setProject(project);
                cellEditor.setReferredFile(this.getFile(element));
                if ("".equalsIgnoreCase(cellEditor.getSeparator())) {
                    cellEditor.setResourceDescription(ResourceBoundle.getString("FileCellEditor.Msg"));
                } else {
                    cellEditor.setResourceDescription(ResourceBoundle.getString("FileCellEditor.Msg1"));
                }
                if ("WEBPATH".equalsIgnoreCase(type)) {
                    cellEditor.setWebPath(true);
                }
                if ("directive.include".equals(element.getLocalName()) || "include".equals(element.getLocalName())) {
                    cellEditor.setTransformJSPURL(false);
                }
                return cellEditor;
            }
        } else {
            if ("CLASSPATH_RESOURCE".equalsIgnoreCase(type)) {
                return new LoadbundleSelectionCellEditor(parent, this.getProject(element));
            }
            if (!"CSSID".equalsIgnoreCase(type)) {
                if ("CSSCLASS".equalsIgnoreCase(type)) {
                    String[] cssclasses = CSSUtil.getCSSClasses(element.getOwnerDocument());
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (cssclasses != null) {
                        int i = 0;
                        while (i < cssclasses.length) {
                            map.put(cssclasses[i], cssclasses[i]);
                            ++i;
                        }
                    }
                    return LabeledComboBoxCellEditor.newInstance(parent, map, 0);
                }
                if ("BOOLEAN".equalsIgnoreCase(type)) {
                    String defaultValue = attr.getParameterByName("default");
                    HashMap<String, String> booleanMap = new HashMap<String, String>();
                    booleanMap.put(Boolean.TRUE.toString(), Boolean.TRUE.toString());
                    booleanMap.put(Boolean.FALSE.toString(), Boolean.FALSE.toString());
                    if (defaultValue == null) {
                        return LabeledComboBoxCellEditor.newInstance(parent, booleanMap, 0);
                    }
                    return LabeledStyleComboCellEditor.newInstance(parent, booleanMap, defaultValue, 0);
                }
                if ("CSSSTYLE".equalsIgnoreCase(type)) {
                    String param = attr.getParameterByName("style");
                    if (!param.equalsIgnoreCase("STYLE")) {
                        return null;
                    }
                    CSSDialogCellEditor cellEditor = new CSSDialogCellEditor(parent, (IDOMElement)element);
                    return cellEditor;
                }
                if ("NAMED-BOOLEAN".equalsIgnoreCase(type)) {
                    return NamedBooleanCellEditor.newInstance(parent, 0, (IDOMElement)element, attr);
                }
                if ("CURRENCYCODE".equalsIgnoreCase(type)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    int i = 0;
                    int n = CURRENCYCODES.length;
                    while (i < n) {
                        map.put(CURRENCYCODES[i], CURRENCYCODES[i]);
                        ++i;
                    }
                    return LabeledComboBoxCellEditor.newInstance(parent, map, 0);
                }
            }
        }
        return null;
    }

    public DialogField createDialogField(IAttributeDescriptor attr) {
        String type = attr.getValueType();
        if ("ENUMERATED".equalsIgnoreCase(type) || "LOCALE".equalsIgnoreCase(type) || "TIMEZONE".equalsIgnoreCase(type)) {
            int i;
            Map<String, String> map = new HashMap();
            if ("ENUMERATED".equalsIgnoreCase(type)) {
                map = attr.getOptions();
            } else if ("LOCALE".equalsIgnoreCase(type)) {
                Locale[] locales = Locale.getAvailableLocales();
                i = 0;
                int size = locales.length;
                while (i < size) {
                    map.put(locales[i].toString(), locales[i].toString());
                    ++i;
                }
            } else {
                String[] ids = TimeZone.getAvailableIDs();
                i = 0;
                int size = ids.length;
                while (i < size) {
                    map.put(ids[i], ids[i]);
                    ++i;
                }
            }
            if (map != null && !map.isEmpty()) {
                String defaultValue = attr.getDefaultValue();
                if (defaultValue == null || "".equals(defaultValue)) {
                    attr.getParameterByName("default");
                }
                StyleComboDialogField field = new StyleComboDialogField(0);
                field.setDefaultValue(defaultValue);
                field.setLabelText(attr.getLabelString());
                field.setEntryMap(new TreeMap(map));
                field.setRequired(attr.isRequired());
                field.setToolTip(attr.getDescription());
                return field;
            }
        } else {
            if ("RELATIVEPATH".equalsIgnoreCase(type)) {
                String param = attr.getTypeParameter();
                ContextableResourceButtonDialogField field = new ContextableResourceButtonDialogField();
                field.setLabelText(attr.getLabelString());
                if (param != null) {
                    field.setSuffixs(attr.getParameterByName("suffix").split(";"));
                }
                field.setResourceDescription(ResourceBoundle.getString("FileCellEditor.Msg"));
                field.setRequired(attr.isRequired());
                field.setToolTip(attr.getDescription());
                return field;
            }
            if ("WEBPATH".equalsIgnoreCase(type)) {
                String param = attr.getTypeParameter();
                ContextableResourceButtonDialogField field = new ContextableResourceButtonDialogField();
                field.setLabelText(attr.getLabelString());
                if (param != null) {
                    field.setSuffixs(attr.getParameterByName("suffix").split(";"));
                    field.setSeparator(attr.getParameterByName("separator"));
                }
                if ("".equalsIgnoreCase(field.getSeparator())) {
                    field.setResourceDescription(ResourceBoundle.getString("FileCellEditor.Msg"));
                } else {
                    field.setResourceDescription(ResourceBoundle.getString("FileCellEditor.Msg1"));
                }
                field.setWebPath(true);
                field.setRequired(attr.isRequired());
                field.setToolTip(attr.getDescription());
                return field;
            }
            if ("CLASSPATH_RESOURCE".equals(type)) {
                ContextableClasspathResourceButtonDialogField field = new ContextableClasspathResourceButtonDialogField();
                field.setRequired(attr.isRequired());
                field.setToolTip(attr.getDescription());
                return field;
            }
            if ("BOOLEAN".equalsIgnoreCase(type)) {
                String defaultValue = attr.getParameterByName("default");
                StyleComboDialogField field = new StyleComboDialogField(0);
                TreeMap<String, String> map = new TreeMap<String, String>();
                map.put("", "");
                map.put(Boolean.FALSE.toString(), Boolean.FALSE.toString());
                map.put(Boolean.TRUE.toString(), Boolean.TRUE.toString());
                field.setEntryMap(map);
                field.setDefaultValue(defaultValue);
                field.setLabelText(attr.getLabelString());
                field.setRequired(attr.isRequired());
                field.setToolTip(attr.getDescription());
                return field;
            }
            if ("CSSSTYLE".equalsIgnoreCase(type)) {
                String param = attr.getParameterByName("style");
                if (!"STYLE".equalsIgnoreCase(param)) {
                    return null;
                }
                StyleButtonDialogField field = new StyleButtonDialogField();
                field.setRequired(attr.isRequired());
                field.setToolTip(attr.getDescription());
                return field;
            }
            if ("CURRENCYCODE".equalsIgnoreCase(type)) {
                ComboDialogField field = new ComboDialogField(0);
                field.setLabelText(attr.getLabelString());
                field.setItems(CURRENCYCODES);
                field.setRequired(attr.isRequired());
                field.setToolTip(attr.getDescription());
                return field;
            }
        }
        return null;
    }

    private IProject getProject(Element element) {
        IDOMModel model;
        IFile file;
        if (element instanceof IDOMElement && (file = StructuredModelUtil.getFileFor((IStructuredModel)(model = ((IDOMElement)element).getModel()))) != null) {
            return file.getProject();
        }
        return null;
    }

    public String[] getSupportedValueTypes() {
        return null;
    }

    private IFile getFile(Element element) {
        if (element instanceof IDOMElement) {
            IDOMModel model = ((IDOMElement)element).getModel();
            IFile file = StructuredModelUtil.getFileFor((IStructuredModel)model);
            return file;
        }
        return null;
    }
}

