/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import java.util.Arrays;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultMovementRule;
import org.eclipse.jst.pagedesigner.validation.caret.JSFRootContainerPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.RootContainerPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.w3c.dom.Node;

public class ContainerMoveInAndOutRule
extends DefaultMovementRule {
    public final String[] HTML_CONTAINERS = new String[]{"table"};
    public final String[] NONE_HTML_CONTAINERS = new String[0];
    public final String[] SPECIAL_HTML_CONTAINERS = new String[]{"outputLink", "commandLink", "facet", "verbatim"};

    public ContainerMoveInAndOutRule(ActionData actionData) {
        super(actionData);
    }

    public boolean allowsMoveIn(Target target) {
        Node node = target.getNode();
        return (node.getLocalName() == null || !Arrays.asList(this.HTML_CONTAINERS).contains(node.getLocalName().toLowerCase())) && !Arrays.asList(this.NONE_HTML_CONTAINERS).contains(node.getLocalName()) && !Arrays.asList(this.SPECIAL_HTML_CONTAINERS).contains(node.getLocalName());
    }

    public boolean allowsMoveOut(Target target) {
        Node node = target.getNode();
        if (EditModelQuery.isDocument(node)) {
            return false;
        }
        if (this._actionData.getActionType() == 5 && ("td".equalsIgnoreCase(node.getLocalName()) || "th".equalsIgnoreCase(node.getLocalName()))) {
            return false;
        }
        if (node.getLocalName() != null && Arrays.asList(this.HTML_CONTAINERS).contains(node.getLocalName().toLowerCase()) || Arrays.asList(this.NONE_HTML_CONTAINERS).contains(node.getLocalName())) {
            return false;
        }
        return node.getLocalName() == null || !Arrays.asList(RootContainerPositionRule.HTML_ROOT_CONTAINERS).contains(node.getLocalName().toLowerCase()) && !Arrays.asList(JSFRootContainerPositionRule.JSF_ROOT_CONTAINERS).contains(node.getLocalName()) || EditModelQuery.isChild(JSFRootContainerPositionRule.JSF_ROOT_CONTAINERS, node, false, true) || EditModelQuery.isChild(RootContainerPositionRule.HTML_ROOT_CONTAINERS, node, true, true);
    }
}

