/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.pskstore.StaticPskStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.leshan.client.EndpointsManager;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.californium.EndpointContextUtil;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.request.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumEndpointsManager
implements EndpointsManager {
    private static final Logger LOG = LoggerFactory.getLogger(CaliforniumEndpointsManager.class);
    protected boolean started = false;
    protected ServerIdentity currentServer;
    protected CoapEndpoint currentEndpoint;
    protected DtlsConnectorConfig.Builder dtlsConfigbuilder;
    protected NetworkConfig coapConfig;
    protected InetSocketAddress localAddress;
    protected CoapServer coapServer;
    protected EndpointFactory endpointFactory;

    public CaliforniumEndpointsManager(InetSocketAddress localAddress, NetworkConfig coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory) {
        this.localAddress = localAddress;
        this.coapConfig = coapConfig;
        this.dtlsConfigbuilder = dtlsConfigBuilder;
        this.endpointFactory = endpointFactory;
    }

    public void setCoapServer(CoapServer coapServer) {
        this.coapServer = coapServer;
    }

    public synchronized ServerIdentity createEndpoint(ServerInfo serverInfo) {
        Identity serverIdentity;
        if (this.currentEndpoint != null) {
            this.coapServer.getEndpoints().remove(this.currentEndpoint);
            this.currentEndpoint.destroy();
        }
        if (serverInfo.isSecure()) {
            DtlsConnectorConfig.Builder newBuilder = new DtlsConnectorConfig.Builder(this.dtlsConfigbuilder.getIncompleteConfig());
            if (serverInfo.secureMode == SecurityMode.PSK) {
                StaticPskStore staticPskStore = new StaticPskStore(serverInfo.pskId, serverInfo.pskKey);
                newBuilder.setPskStore((PskStore)staticPskStore);
                serverIdentity = Identity.psk((InetSocketAddress)serverInfo.getAddress(), (String)serverInfo.pskId);
            } else if (serverInfo.secureMode == SecurityMode.RPK) {
                newBuilder.setIdentity(serverInfo.privateKey, serverInfo.publicKey);
                final PublicKey expectedKey = serverInfo.serverPublicKey;
                newBuilder.setRpkTrustStore(new TrustedRpkStore(){

                    public boolean isTrusted(RawPublicKeyIdentity id) {
                        PublicKey receivedKey = id.getKey();
                        if (receivedKey == null) {
                            LOG.warn("The server public key is null {}", (Object)id);
                            return false;
                        }
                        if (!receivedKey.equals(expectedKey)) {
                            LOG.debug("Server public key received does match with the expected one.\nReceived: {}\nExpected: {}", (Object)receivedKey, (Object)expectedKey);
                            return false;
                        }
                        return true;
                    }
                });
                serverIdentity = Identity.rpk((InetSocketAddress)serverInfo.getAddress(), (PublicKey)expectedKey);
            } else if (serverInfo.secureMode == SecurityMode.X509) {
                newBuilder.setIdentity(serverInfo.privateKey, new Certificate[]{serverInfo.clientCertificate}, new CertificateType[0]);
                final Certificate expectedServerCertificate = serverInfo.serverCertificate;
                newBuilder.setCertificateVerifier(new CertificateVerifier(){

                    public void verifyCertificate(CertificateMessage message, DTLSSession session) throws HandshakeException {
                        if (message.getCertificateChain().getCertificates().size() == 0) {
                            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                            throw new HandshakeException("Certificate chain could not be validated", alert);
                        }
                        Certificate receivedServerCertificate = message.getCertificateChain().getCertificates().get(0);
                        if (!expectedServerCertificate.equals(receivedServerCertificate)) {
                            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                            throw new HandshakeException("Certificate chain could not be validated", alert);
                        }
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                });
                serverIdentity = Identity.x509((InetSocketAddress)serverInfo.getAddress(), (String)EndpointContextUtil.extractCN((String)((X509Certificate)expectedServerCertificate).getSubjectX500Principal().getName()));
            } else {
                throw new RuntimeException("Unable to create connector : unsupported security mode");
            }
            this.currentEndpoint = this.endpointFactory.createSecuredEndpoint(newBuilder.build(), this.coapConfig, null);
        } else {
            this.currentEndpoint = this.endpointFactory.createUnsecuredEndpoint(this.localAddress, this.coapConfig, null);
            serverIdentity = Identity.unsecure((InetSocketAddress)serverInfo.getAddress());
        }
        this.coapServer.addEndpoint((Endpoint)this.currentEndpoint);
        this.currentServer = serverInfo.bootstrap ? new ServerIdentity(serverIdentity, Long.valueOf(serverInfo.serverId), ServerIdentity.Role.LWM2M_BOOTSTRAP_SERVER) : new ServerIdentity(serverIdentity, Long.valueOf(serverInfo.serverId));
        if (this.started) {
            this.coapServer.start();
            try {
                this.currentEndpoint.start();
                LOG.info("New endpoint created for server {} at {}", (Object)this.currentServer.getUri(), (Object)this.currentEndpoint.getUri());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to start endpoint", e);
            }
        }
        return this.currentServer;
    }

    public synchronized Collection<ServerIdentity> createEndpoints(Collection<? extends ServerInfo> serverInfo) {
        if (serverInfo == null || serverInfo.isEmpty()) {
            return null;
        }
        if (serverInfo.size() > 1) {
            LOG.warn("CaliforniumEndpointsManager support only connection to 1 LWM2M server, first server will be used from the server list of {}", (Object)serverInfo.size());
        }
        ServerInfo firstServer = serverInfo.iterator().next();
        ArrayList<ServerIdentity> servers = new ArrayList<ServerIdentity>(1);
        servers.add(this.createEndpoint(firstServer));
        return servers;
    }

    public long getMaxCommunicationPeriodFor(ServerIdentity server, long lifetimeInMs) {
        int floor = 30000;
        long exchange_lifetime = this.coapConfig.getLong("EXCHANGE_LIFETIME", 247L);
        if (lifetimeInMs - exchange_lifetime >= (long)floor) {
            return lifetimeInMs - exchange_lifetime;
        }
        LOG.warn("Too small lifetime : we advice to not use a lifetime < (COAP EXCHANGE LIFETIME + 30s)");
        return lifetimeInMs * (long)(floor - 1000) / (exchange_lifetime + (long)floor) + 1000L;
    }

    public synchronized void forceReconnection(ServerIdentity server, boolean resume) {
        if (server == null || !server.equals((Object)this.currentServer)) {
            return;
        }
        Connector connector = this.currentEndpoint.getConnector();
        if (connector instanceof DTLSConnector) {
            if (resume) {
                LOG.info("Clear DTLS session for resumption for server {}", (Object)server.getUri());
                ((DTLSConnector)connector).forceResumeAllSessions();
            } else {
                LOG.info("Clear DTLS session for server {}", (Object)server.getUri());
                ((DTLSConnector)connector).clearConnectionState();
            }
        }
    }

    public synchronized Endpoint getEndpoint(ServerIdentity server) {
        if (server != null && server.equals((Object)this.currentServer) && this.currentEndpoint.isStarted()) {
            return this.currentEndpoint;
        }
        return null;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.currentEndpoint == null) {
            return;
        }
        this.coapServer.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.currentEndpoint == null) {
            return;
        }
        this.coapServer.stop();
    }

    public synchronized void destroy() {
        if (this.started) {
            this.started = false;
        }
        this.coapServer.destroy();
    }
}

