/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.util.List;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.bootstrap.BootstrapHandler;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.util.StringUtils;

public class RootResource
extends LwM2mClientCoapResource {
    protected CoapServer coapServer;
    protected BootstrapHandler bootstrapHandler;

    public RootResource(RegistrationEngine registrationEngine, BootstrapHandler bootstrapHandler, CoapServer coapServer) {
        super("", registrationEngine);
        this.bootstrapHandler = bootstrapHandler;
        this.setVisible(false);
        this.coapServer = coapServer;
    }

    public void handleGET(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.NOT_FOUND);
    }

    public void handleDELETE(CoapExchange exchange) {
        if (!StringUtils.isEmpty((String)exchange.getRequestOptions().getUriPathString())) {
            exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
            return;
        }
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        BootstrapDeleteResponse response = this.bootstrapHandler.delete(identity, new BootstrapDeleteRequest());
        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
    }

    public List<Endpoint> getEndpoints() {
        return this.coapServer.getEndpoints();
    }
}

