/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.leshan.client.californium.LeshanClient;
import org.eclipse.leshan.client.engine.DefaultRegistrationEngineFactory;
import org.eclipse.leshan.client.engine.RegistrationEngineFactory;
import org.eclipse.leshan.client.object.Device;
import org.eclipse.leshan.client.object.Security;
import org.eclipse.leshan.client.object.Server;
import org.eclipse.leshan.client.resource.LwM2mInstanceEnabler;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.resource.ObjectsInitializer;
import org.eclipse.leshan.core.californium.DefaultEndpointFactory;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mNodeEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeEncoder;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.util.Validate;

public class LeshanClientBuilder {
    private final String endpoint;
    private InetSocketAddress localAddress;
    private List<? extends LwM2mObjectEnabler> objectEnablers;
    private NetworkConfig coapConfig;
    private DtlsConnectorConfig.Builder dtlsConfigBuilder;
    private LwM2mNodeEncoder encoder;
    private LwM2mNodeDecoder decoder;
    private EndpointFactory endpointFactory;
    private RegistrationEngineFactory engineFactory;
    private Map<String, String> additionalAttributes;
    private ScheduledExecutorService executor;
    protected Map<String, String> bsAdditionalAttributes;

    public LeshanClientBuilder(String endpoint) {
        Validate.notEmpty((String)endpoint);
        this.endpoint = endpoint;
    }

    public LeshanClientBuilder setLocalAddress(String hostname, int port) {
        this.localAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanClientBuilder setObjects(List<? extends LwM2mObjectEnabler> objectEnablers) {
        this.objectEnablers = objectEnablers;
        return this;
    }

    public LeshanClientBuilder setEncoder(LwM2mNodeEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public LeshanClientBuilder setDecoder(LwM2mNodeDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public LeshanClientBuilder setCoapConfig(NetworkConfig config) {
        this.coapConfig = config;
        return this;
    }

    public LeshanClientBuilder setDtlsConfig(DtlsConnectorConfig.Builder config) {
        this.dtlsConfigBuilder = config;
        return this;
    }

    public LeshanClientBuilder setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public LeshanClientBuilder setRegistrationEngineFactory(RegistrationEngineFactory engineFactory) {
        this.engineFactory = engineFactory;
        return this;
    }

    public LeshanClientBuilder setAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
        return this;
    }

    public LeshanClientBuilder setBootstrapAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.bsAdditionalAttributes = additionalAttributes;
        return this;
    }

    public LeshanClientBuilder setSharedExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public static NetworkConfig createDefaultNetworkConfig() {
        NetworkConfig networkConfig = new NetworkConfig();
        networkConfig.set("MID_TACKER", (Object)"NULL");
        networkConfig.set("MAX_ACTIVE_PEERS", (Object)10);
        networkConfig.set("PROTOCOL_STAGE_THREAD_COUNT", (Object)1);
        return networkConfig;
    }

    public LeshanClient build() {
        DtlsConnectorConfig incompleteConfig;
        if (this.localAddress == null) {
            this.localAddress = new InetSocketAddress(0);
        }
        if (this.objectEnablers == null) {
            ObjectsInitializer initializer = new ObjectsInitializer();
            initializer.setInstancesForObject(0, new LwM2mInstanceEnabler[]{Security.noSec((String)"coap://leshan.eclipseprojects.io:5683", (int)12345)});
            initializer.setInstancesForObject(1, new LwM2mInstanceEnabler[]{new Server(12345, 300L, BindingMode.U, false)});
            initializer.setInstancesForObject(3, new LwM2mInstanceEnabler[]{new Device("Eclipse Leshan", "model12345", "12345", "U")});
            this.objectEnablers = initializer.createAll();
        }
        if (this.encoder == null) {
            this.encoder = new DefaultLwM2mNodeEncoder();
        }
        if (this.decoder == null) {
            this.decoder = new DefaultLwM2mNodeDecoder();
        }
        if (this.coapConfig == null) {
            this.coapConfig = LeshanClientBuilder.createDefaultNetworkConfig();
        }
        if (this.engineFactory == null) {
            this.engineFactory = new DefaultRegistrationEngineFactory();
        }
        if (this.endpointFactory == null) {
            this.endpointFactory = new DefaultEndpointFactory("LWM2M Client"){

                protected Connector createSecuredConnector(DtlsConnectorConfig dtlsConfig) {
                    DTLSConnector dtlsConnector = new DTLSConnector(dtlsConfig);
                    if (LeshanClientBuilder.this.executor != null) {
                        dtlsConnector.setExecutor((ExecutorService)LeshanClientBuilder.this.executor);
                    }
                    return dtlsConnector;
                }
            };
        }
        if (this.dtlsConfigBuilder == null) {
            this.dtlsConfigBuilder = new DtlsConnectorConfig.Builder();
        }
        if ((incompleteConfig = this.dtlsConfigBuilder.getIncompleteConfig()).getAddress() == null) {
            if (this.localAddress == null) {
                this.localAddress = new InetSocketAddress(0);
            }
            this.dtlsConfigBuilder.setAddress(this.localAddress);
        } else if (this.localAddress != null && !this.localAddress.equals(incompleteConfig.getAddress())) {
            throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for address: %s != %s", this.localAddress, incompleteConfig.getAddress()));
        }
        if (incompleteConfig.getMaxConnections() == null) {
            this.dtlsConfigBuilder.setMaxConnections(this.coapConfig.getInt("MAX_ACTIVE_PEERS"));
        }
        if (incompleteConfig.getStaleConnectionThreshold() == null) {
            this.dtlsConfigBuilder.setStaleConnectionThreshold(this.coapConfig.getLong("MAX_PEER_INACTIVITY_PERIOD"));
        }
        if (incompleteConfig.getConnectionThreadCount() == null) {
            this.dtlsConfigBuilder.setConnectionThreadCount(1);
        }
        if (incompleteConfig.getReceiverThreadCount() == null) {
            this.dtlsConfigBuilder.setReceiverThreadCount(1);
        }
        if (incompleteConfig.isSniEnabled() == null) {
            this.dtlsConfigBuilder.setSniEnabled(false);
        }
        return this.createLeshanClient(this.endpoint, this.localAddress, this.objectEnablers, this.coapConfig, this.dtlsConfigBuilder, this.endpointFactory, this.engineFactory, this.additionalAttributes, this.encoder, this.decoder, this.executor);
    }

    protected LeshanClient createLeshanClient(String endpoint, InetSocketAddress localAddress, List<? extends LwM2mObjectEnabler> objectEnablers, NetworkConfig coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory, RegistrationEngineFactory engineFactory, Map<String, String> additionalAttributes, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder, ScheduledExecutorService sharedExecutor) {
        return new LeshanClient(endpoint, localAddress, objectEnablers, coapConfig, dtlsConfigBuilder, endpointFactory, engineFactory, additionalAttributes, this.bsAdditionalAttributes, encoder, decoder, this.executor);
    }
}

