/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.californium.endpoint.ServerIdentityExtractor;
import org.eclipse.leshan.client.endpoint.ClientEndpointToolbox;
import org.eclipse.leshan.client.request.DownlinkRequestReceiver;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ObserveUtil;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.util.StringUtils;

public class RootResource
extends LwM2mClientCoapResource {
    protected DownlinkRequestReceiver requestReceiver;
    protected ClientEndpointToolbox toolbox;

    public RootResource(IdentityHandlerProvider identityHandlerProvider, ServerIdentityExtractor serverIdentityExtractor, CoapServer coapServer, DownlinkRequestReceiver requestReceiver, ClientEndpointToolbox toolbox) {
        super("", identityHandlerProvider, serverIdentityExtractor);
        this.setVisible(false);
        this.setObservable(true);
        this.requestReceiver = requestReceiver;
        this.toolbox = toolbox;
    }

    public void handleGET(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mServer server = this.getServerOrRejectRequest(exchange, (Message)coapRequest);
        if (server == null) {
            return;
        }
        String URI = exchange.getRequestOptions().getUriPathString();
        BootstrapDiscoverResponse response = (BootstrapDiscoverResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)new BootstrapDiscoverRequest(URI, (Object)coapRequest)).getResponse();
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.toolbox.getLinkSerializer().serializeCoreLinkFormat((Link[])response.getObjectLinks()), 40);
        }
    }

    public void handleFETCH(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mServer server = this.getServerOrRejectRequest(exchange, (Message)coapRequest);
        if (server == null) {
            return;
        }
        ContentFormat responseContentFormat = ContentFormat.SENML_CBOR;
        if (exchange.getRequestOptions().hasAccept()) {
            responseContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getAccept());
            if (!this.toolbox.getEncoder().isSupported(responseContentFormat)) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
        }
        if (!exchange.getRequestOptions().hasContentFormat()) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
            return;
        }
        ContentFormat requestContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        List paths = this.toolbox.getDecoder().decodePaths(coapRequest.getPayload(), requestContentFormat);
        if (exchange.getRequestOptions().hasObserve()) {
            ObserveCompositeRequest observeRequest = new ObserveCompositeRequest(requestContentFormat, responseContentFormat, paths, (Object)coapRequest);
            ObserveCompositeResponse response = (ObserveCompositeResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)observeRequest).getResponse();
            this.updateUserContextWithPaths(coapRequest, paths);
            if (response.getCode().isError()) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.toolbox.getEncoder().encodeNodes(response.getContent(), responseContentFormat, this.toolbox.getModel()), responseContentFormat.getCode());
            return;
        }
        ReadCompositeResponse response = (ReadCompositeResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)new ReadCompositeRequest(paths, requestContentFormat, responseContentFormat, (Object)coapRequest)).getResponse();
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.toolbox.getEncoder().encodeNodes(response.getContent(), responseContentFormat, this.toolbox.getModel()), responseContentFormat.getCode());
        }
    }

    private void updateUserContextWithPaths(Request coapRequest, List<LwM2mPath> paths) {
        HashMap userContext = new HashMap();
        if (coapRequest.getUserContext() != null) {
            userContext.putAll(coapRequest.getUserContext());
        }
        ObserveUtil.addPathsIntoContext(userContext, paths);
        coapRequest.setUserContext(userContext);
    }

    public void handleIPATCH(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mServer server = this.getServerOrRejectRequest(exchange, (Message)coapRequest);
        if (server == null) {
            return;
        }
        ContentFormat contentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        if (!this.toolbox.getDecoder().isSupported(contentFormat)) {
            exchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);
            return;
        }
        Map nodes = this.toolbox.getDecoder().decodeNodes(coapRequest.getPayload(), contentFormat, null, this.toolbox.getModel());
        WriteCompositeResponse response = (WriteCompositeResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)new WriteCompositeRequest(contentFormat, nodes, (Object)coapRequest)).getResponse();
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
        }
    }

    public void handleDELETE(CoapExchange exchange) {
        String URI = exchange.getRequestOptions().getUriPathString();
        if (!StringUtils.isEmpty((String)URI)) {
            exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
            return;
        }
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mServer server = this.getServerOrRejectRequest(exchange, (Message)coapRequest);
        if (server == null) {
            return;
        }
        BootstrapDeleteResponse response = (BootstrapDeleteResponse)this.requestReceiver.requestReceived(server, (DownlinkRequest)new BootstrapDeleteRequest(URI, (Object)coapRequest)).getResponse();
        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
    }
}

