/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.leshan.client.californium.CaliforniumConnectionController;
import org.eclipse.leshan.client.californium.endpoint.ClientCoapMessageTranslator;
import org.eclipse.leshan.client.endpoint.ClientEndpointToolbox;
import org.eclipse.leshan.client.endpoint.LwM2mClientEndpoint;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.core.californium.AsyncRequestObserver;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.SyncRequestObserver;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumClientEndpoint
implements LwM2mClientEndpoint {
    private final Logger LOG = LoggerFactory.getLogger(CaliforniumClientEndpoint.class);
    private final Protocol protocol;
    private final String description;
    private final ScheduledExecutorService executor;
    private final CoapEndpoint endpoint;
    private final ClientEndpointToolbox toolbox;
    private final ClientCoapMessageTranslator translator;
    private final IdentityHandler identityHandler;
    private final CaliforniumConnectionController connectionController;
    private final LwM2mModel model;
    private final ExceptionTranslator exceptionTranslator;

    public CaliforniumClientEndpoint(Protocol protocol, String description, CoapEndpoint endpoint, ClientCoapMessageTranslator translator, ClientEndpointToolbox toolbox, IdentityHandler identityHandler, CaliforniumConnectionController connectionController, LwM2mModel model, ExceptionTranslator exceptionTranslator, ScheduledExecutorService executor) {
        this.protocol = protocol;
        this.description = description;
        this.translator = translator;
        this.toolbox = toolbox;
        this.endpoint = endpoint;
        this.identityHandler = identityHandler;
        this.connectionController = connectionController;
        this.model = model;
        this.exceptionTranslator = exceptionTranslator;
        this.executor = executor;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public URI getURI() {
        try {
            return new URI(this.protocol.getUriScheme(), null, this.getCoapEndpoint().getAddress().getHostString(), this.getCoapEndpoint().getAddress().getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public long getMaxCommunicationPeriodFor(long lifetimeInMs) {
        int floor = 30000;
        long exchange_lifetime = this.endpoint.getConfig().get(CoapConfig.EXCHANGE_LIFETIME, TimeUnit.MILLISECONDS);
        if (lifetimeInMs - exchange_lifetime >= (long)floor) {
            return lifetimeInMs - exchange_lifetime;
        }
        this.LOG.warn("Too small lifetime : we advice to not use a lifetime < (COAP EXCHANGE LIFETIME + 30s)");
        return lifetimeInMs * (long)(floor - 1000) / (exchange_lifetime + (long)floor) + 1000L;
    }

    public <T extends LwM2mResponse> T send(final LwM2mServer server, final UplinkRequest<T> lwm2mRequest, long timeoutInMs) throws InterruptedException {
        final Request coapRequest = this.translator.createCoapRequest(server, lwm2mRequest, this.toolbox, this.model, this.identityHandler);
        SyncRequestObserver syncMessageObserver = new SyncRequestObserver<T>(coapRequest, timeoutInMs, this.exceptionTranslator){

            public T buildResponse(Response coapResponse) {
                Object lwM2mResponse = CaliforniumClientEndpoint.this.translator.createLwM2mResponse(server, lwm2mRequest, coapRequest, coapResponse, CaliforniumClientEndpoint.this.toolbox);
                return lwM2mResponse;
            }
        };
        coapRequest.addMessageObserver((MessageObserver)syncMessageObserver);
        this.endpoint.sendRequest(coapRequest);
        return (T)syncMessageObserver.waitForResponse();
    }

    public <T extends LwM2mResponse> void send(final LwM2mServer server, final UplinkRequest<T> lwm2mRequest, ResponseCallback<T> responseCallback, ErrorCallback errorCallback, long timeoutInMs) {
        Validate.notNull(responseCallback);
        Validate.notNull((Object)errorCallback);
        final Request coapRequest = this.translator.createCoapRequest(server, lwm2mRequest, this.toolbox, this.model, this.identityHandler);
        AsyncRequestObserver obs = new AsyncRequestObserver<T>(coapRequest, responseCallback, errorCallback, timeoutInMs, this.executor, this.exceptionTranslator){

            public T buildResponse(Response coapResponse) {
                Object lwM2mResponse = CaliforniumClientEndpoint.this.translator.createLwM2mResponse(server, lwm2mRequest, coapRequest, coapResponse, CaliforniumClientEndpoint.this.toolbox);
                return lwM2mResponse;
            }
        };
        coapRequest.addMessageObserver((MessageObserver)obs);
        this.endpoint.sendRequest(coapRequest);
    }

    public void forceReconnection(LwM2mServer server, boolean resume) {
        this.connectionController.forceReconnection((Endpoint)this.endpoint, server, resume);
    }

    public CoapEndpoint getCoapEndpoint() {
        return this.endpoint;
    }
}

